/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.debugger.dto;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.util.debugger.dto.BreakPointDTO;
import org.ballerinalang.util.debugger.dto.FrameDTO;
import org.ballerinalang.util.debugger.dto.VariableDTO;

public class MessageDTO {
    private String code;
    private String message;
    private String threadId;
    private BreakPointDTO location;
    private List<FrameDTO> frames = new ArrayList<FrameDTO>();

    public MessageDTO(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public BreakPointDTO getLocation() {
        return this.location;
    }

    public void setLocation(BreakPointDTO location) {
        this.location = location;
    }

    public void addFrame(FrameDTO frameDTO) {
        this.frames.add(frameDTO);
    }

    public List<FrameDTO> getFrames() {
        return this.frames;
    }

    public String toString() {
        StringBuilder br = new StringBuilder();
        br.append("====BreakPointInfo {").append(this.location.toString()).append("}====\n");
        br.append("Frames ->\n");
        for (FrameDTO frame : this.frames) {
            br.append("    ").append(frame.toString()).append("\n");
        }
        br.append("Last Frame variables->\n");
        if (this.frames.size() > 0) {
            FrameDTO frame = this.frames.get(this.frames.size() - 1);
            for (VariableDTO var : frame.getVariables()) {
                br.append("    ").append(var.toString()).append("\n");
            }
        }
        br.append("====End Break Point Info====");
        return br.toString();
    }
}

