/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.util.metrics.DefaultMetricRegistry;
import org.ballerinalang.util.metrics.Metric;
import org.ballerinalang.util.metrics.MetricId;
import org.ballerinalang.util.metrics.MetricRegistry;
import org.ballerinalang.util.metrics.Tag;
import org.ballerinalang.util.metrics.Tags;

public interface Gauge
extends Metric {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    default public void increment() {
        this.increment(1.0);
    }

    public void increment(double var1);

    default public void decrement() {
        this.decrement(1.0);
    }

    public void decrement(double var1);

    public void set(double var1);

    public double get();

    public static class Builder
    implements Metric.Builder<Builder, Gauge> {
        private final String name;
        private final Set<Tag> tags = new HashSet<Tag>(10);
        private String description;

        private Builder(String name) {
            this.name = name;
        }

        @Override
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder tags(String ... keyValues) {
            Tags.tags(this.tags, keyValues);
            return this;
        }

        @Override
        public Builder tags(Iterable<Tag> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Builder tag(String key, String value) {
            Tags.tags(this.tags, key, value);
            return this;
        }

        @Override
        public Builder tags(Map<String, String> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Gauge register() {
            return this.register(DefaultMetricRegistry.getInstance());
        }

        @Override
        public Gauge register(MetricRegistry registry) {
            return registry.gauge(new MetricId(this.name, this.description, this.tags));
        }
    }
}

