/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.ballerinalang.bre.bvm.BLangScheduler;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.util.LaunchListener;
import org.ballerinalang.util.metrics.BallerinaMetricsObserver;
import org.ballerinalang.util.metrics.CallbackGauge;
import org.ballerinalang.util.metrics.DefaultMetricRegistry;
import org.ballerinalang.util.metrics.Gauge;
import org.ballerinalang.util.metrics.MetricRegistry;
import org.ballerinalang.util.metrics.noop.NoOpMetricProvider;
import org.ballerinalang.util.metrics.spi.MetricProvider;
import org.ballerinalang.util.observability.ObservabilityUtils;

public class MetricsLaunchListener
implements LaunchListener {
    private static final String METRIC_PROVIDER_NAME = "b7a.observability.metrics.provider";

    @Override
    public void beforeRunProgram(boolean service) {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        if (!configRegistry.getAsBoolean("b7a.observability.metrics.enabled")) {
            DefaultMetricRegistry.setInstance(new MetricRegistry(new NoOpMetricProvider()));
            return;
        }
        String providerName = configRegistry.getAsString(METRIC_PROVIDER_NAME);
        Iterator<MetricProvider> metricProviders = ServiceLoader.load(MetricProvider.class).iterator();
        MetricProvider metricProvider = null;
        while (metricProviders.hasNext()) {
            MetricProvider temp = metricProviders.next();
            if (providerName != null && providerName.equalsIgnoreCase(temp.getName())) {
                metricProvider = temp;
                break;
            }
            if (NoOpMetricProvider.class.isInstance(temp)) continue;
            metricProvider = temp;
            break;
        }
        if (metricProvider == null) {
            metricProvider = new NoOpMetricProvider();
        }
        metricProvider.initialize();
        DefaultMetricRegistry.setInstance(new MetricRegistry(metricProvider));
        this.registerBallerinaMetrics();
        ObservabilityUtils.addObserver(new BallerinaMetricsObserver());
    }

    private void registerBallerinaMetrics() {
        BLangScheduler.SchedulerStats schedulerStats = BLangScheduler.getStats();
        String prefix = "ballerina_scheduler_";
        CallbackGauge.builder("ballerina_scheduler_ready_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getReadyWorkerCount).register();
        CallbackGauge.builder("ballerina_scheduler_running_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getRunningWorkerCount).register();
        CallbackGauge.builder("ballerina_scheduler_excepted_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getExceptedWorkerCount).register();
        CallbackGauge.builder("ballerina_scheduler_paused_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getPausedWorkerCount).register();
        CallbackGauge.builder("ballerina_scheduler_waiting_for_response_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getWaitingForResponseWorkerCount).register();
        CallbackGauge.builder("ballerina_scheduler_waiting_for_lock_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getWaitingForLockWorkerCount).register();
    }

    @Override
    public void afterRunProgram(boolean service) {
        if (service) {
            Gauge gauge = Gauge.builder("startup_time_milliseconds").description("Startup time in milliseconds").register();
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            gauge.set(System.currentTimeMillis() - runtimeMXBean.getStartTime());
        }
    }
}

