/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.ballerinalang.util.metrics.DefaultMetricRegistry;
import org.ballerinalang.util.metrics.Metric;
import org.ballerinalang.util.metrics.MetricId;
import org.ballerinalang.util.metrics.MetricRegistry;
import org.ballerinalang.util.metrics.Tag;
import org.ballerinalang.util.metrics.Tags;

public interface Summary
extends Metric {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    public void record(double var1);

    public long count();

    public double mean();

    public double max();

    public SortedMap<Double, Double> percentileValues();

    public static class Builder
    implements Metric.Builder<Builder, Summary> {
        private final String name;
        private final Set<Tag> tags = new HashSet<Tag>(10);
        private String description;

        private Builder(String name) {
            this.name = name;
        }

        @Override
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder tags(String ... keyValues) {
            Tags.tags(this.tags, keyValues);
            return this;
        }

        @Override
        public Builder tags(Iterable<Tag> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Builder tag(String key, String value) {
            Tags.tags(this.tags, key, value);
            return this;
        }

        @Override
        public Builder tags(Map<String, String> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Summary register() {
            return this.register(DefaultMetricRegistry.getInstance());
        }

        @Override
        public Summary register(MetricRegistry registry) {
            return registry.summary(new MetricId(this.name, this.description, this.tags));
        }
    }
}

