/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.util.metrics.DefaultMetricRegistry;
import org.ballerinalang.util.metrics.Metric;
import org.ballerinalang.util.metrics.MetricId;
import org.ballerinalang.util.metrics.MetricRegistry;
import org.ballerinalang.util.metrics.Tag;
import org.ballerinalang.util.metrics.Tags;

public interface Timer
extends Metric {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    public void record(long var1, TimeUnit var3);

    default public void record(Duration duration) {
        this.record(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public long count();

    public double mean(TimeUnit var1);

    public double max(TimeUnit var1);

    public SortedMap<Double, Double> percentileValues(TimeUnit var1);

    public static class Builder
    implements Metric.Builder<Builder, Timer> {
        private final String name;
        private final Set<Tag> tags = new HashSet<Tag>(10);
        private String description;

        private Builder(String name) {
            this.name = name;
        }

        @Override
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder tags(String ... keyValues) {
            Tags.tags(this.tags, keyValues);
            return this;
        }

        @Override
        public Builder tags(Iterable<Tag> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Builder tag(String key, String value) {
            Tags.tags(this.tags, key, value);
            return this;
        }

        @Override
        public Builder tags(Map<String, String> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Timer register() {
            return this.register(DefaultMetricRegistry.getInstance());
        }

        @Override
        public Timer register(MetricRegistry registry) {
            return registry.timer(new MetricId(this.name, this.description, this.tags));
        }
    }
}

