/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.observability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.util.observability.BallerinaObserver;
import org.ballerinalang.util.observability.ObserverContext;
import org.ballerinalang.util.tracer.BSpan;

public class ObservabilityUtils {
    private static final List<BallerinaObserver> observers = new CopyOnWriteArrayList<BallerinaObserver>();
    private static final boolean enabled;

    public static boolean isObservabilityEnabled() {
        return enabled;
    }

    public static void addObserver(BallerinaObserver observer) {
        observers.add(observer);
    }

    public static void removeObserver(BallerinaObserver observer) {
        observers.remove(observer);
    }

    public static Optional<ObserverContext> startServerObservation(String connectorName, String serviceName, String resourceName, WorkerExecutionContext parentContext) {
        if (!enabled) {
            return Optional.empty();
        }
        Objects.requireNonNull(connectorName);
        ObserverContext ctx = new ObserverContext();
        ctx.setConnectorName(connectorName);
        ctx.setServiceName(serviceName);
        ctx.setResourceName(resourceName);
        if (parentContext != null) {
            ObservabilityUtils.continueServerObservation(ctx, parentContext);
        }
        return Optional.of(ctx);
    }

    public static Optional<ObserverContext> startClientObservation(String connectorName, String actionName, WorkerExecutionContext parentCtx) {
        if (!enabled) {
            return Optional.empty();
        }
        Objects.requireNonNull(connectorName);
        ObserverContext ctx = new ObserverContext();
        ctx.setConnectorName(connectorName);
        ctx.setActionName(actionName);
        if (parentCtx != null) {
            ObservabilityUtils.continueClientObservation(ctx, parentCtx);
        }
        return Optional.of(ctx);
    }

    public static void continueServerObservation(ObserverContext observerContext, WorkerExecutionContext parentCtx) {
        if (!enabled) {
            return;
        }
        Objects.requireNonNull(parentCtx);
        ObserverContext parentObserverContext = ObservabilityUtils.populateAndGetParentObserverContext(parentCtx);
        observerContext.setParent(parentObserverContext);
        observerContext.setServer();
        observerContext.setStarted();
        ObserverContext ctx = observerContext;
        observers.forEach(observer -> observer.startServerObservation(ctx));
    }

    public static void continueClientObservation(ObserverContext observerContext, WorkerExecutionContext parentCtx) {
        if (!enabled) {
            return;
        }
        Objects.requireNonNull(parentCtx);
        ObserverContext parentObserverContext = ObservabilityUtils.populateAndGetParentObserverContext(parentCtx);
        observerContext.setParent(parentObserverContext);
        observerContext.setStarted();
        ObserverContext ctx = observerContext;
        observers.forEach(observer -> observer.startClientObservation(ctx));
    }

    public static void stopObservation(ObserverContext observerContext) {
        if (!enabled || observerContext == null) {
            return;
        }
        Objects.requireNonNull(observerContext);
        if (observerContext.isServer()) {
            observers.forEach(observer -> observer.stopServerObservation(observerContext));
        } else {
            observers.forEach(observer -> observer.stopClientObservation(observerContext));
        }
    }

    public static Optional<ObserverContext> getParentContext(Context context) {
        return enabled ? Optional.of(ObservabilityUtils.populateAndGetParentObserverContext(context.getParentWorkerExecutionContext())) : Optional.empty();
    }

    public static Map<String, String> getContextProperties(ObserverContext observerContext) {
        BSpan bSpan = (BSpan)observerContext.getProperty("_span_");
        if (bSpan != null) {
            return bSpan.getTraceContext();
        }
        return Collections.emptyMap();
    }

    public static void setObserverContextToWorkerExecutionContext(WorkerExecutionContext workerExecutionContext, ObserverContext observerContext) {
        if (!enabled || observerContext == null) {
            return;
        }
        if (workerExecutionContext.localProps == null) {
            workerExecutionContext.localProps = new HashMap<String, Object>();
        }
        workerExecutionContext.localProps.put("__observer_context__", observerContext);
    }

    private static ObserverContext populateAndGetParentObserverContext(WorkerExecutionContext parentCtx) {
        ArrayList<WorkerExecutionContext> ancestors = new ArrayList<WorkerExecutionContext>();
        Object ctx = null;
        WorkerExecutionContext parent = parentCtx;
        while (parent != null) {
            Object object = ctx = parent.localProps != null ? parent.localProps.get("__observer_context__") : null;
            if (ctx != null) break;
            ancestors.add(parent);
            parent = parent.parent;
        }
        ObserverContext observerContext = ctx != null ? (ObserverContext)ctx : new ObserverContext();
        ancestors.forEach(w -> {
            if (w.localProps == null) {
                w.localProps = new HashMap<String, Object>();
            }
            w.localProps.put("__observer_context__", observerContext);
        });
        return observerContext;
    }

    static {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        enabled = configRegistry.getAsBoolean("b7a.observability.metrics.enabled") || configRegistry.getAsBoolean("b7a.observability.tracing.enabled");
    }
}

