/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.program;

import java.io.PrintStream;
import org.ballerinalang.bre.bvm.CPU;
import org.ballerinalang.bre.bvm.WorkerData;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBlob;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.BLangConstants;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.codegen.WorkerInfo;
import org.ballerinalang.util.codegen.attributes.CodeAttributeInfo;
import org.ballerinalang.util.program.WorkerDataIndex;
import org.ballerinalang.util.transactions.LocalTransactionInfo;

public class BLangVMUtils {
    private static final String SERVICE_INFO_KEY = "SERVICE_INFO";
    private static final String TRANSACTION_INFO_KEY = "TRANSACTION_INFO";
    private static final String GLOBAL_TRANSACTION_ENABLED = "GLOBAL_TRANSACTION_ENABLED";

    public static void copyArgValues(WorkerData caller, WorkerData callee, int[] argRegs, BType[] paramTypes) {
        int longRegIndex = -1;
        int doubleRegIndex = -1;
        int stringRegIndex = -1;
        int booleanRegIndex = -1;
        int refRegIndex = -1;
        int blobRegIndex = -1;
        block7: for (int i = 0; i < argRegs.length; ++i) {
            BType paramType = paramTypes[i];
            int argReg = argRegs[i];
            switch (paramType.getTag()) {
                case 1: {
                    callee.longRegs[++longRegIndex] = caller.longRegs[argReg];
                    continue block7;
                }
                case 2: {
                    callee.doubleRegs[++doubleRegIndex] = caller.doubleRegs[argReg];
                    continue block7;
                }
                case 3: {
                    callee.stringRegs[++stringRegIndex] = caller.stringRegs[argReg];
                    continue block7;
                }
                case 4: {
                    callee.intRegs[++booleanRegIndex] = caller.intRegs[argReg];
                    continue block7;
                }
                case 5: {
                    callee.byteRegs[++blobRegIndex] = caller.byteRegs[argReg];
                    continue block7;
                }
                default: {
                    callee.refRegs[++refRegIndex] = caller.refRegs[argReg];
                }
            }
        }
    }

    public static void copyValuesForForkJoin(WorkerData caller, WorkerData callee, int[] argRegs) {
        int i;
        int longLocalVals = argRegs[0];
        int doubleLocalVals = argRegs[1];
        int stringLocalVals = argRegs[2];
        int booleanLocalVals = argRegs[3];
        int blobLocalVals = argRegs[4];
        int refLocalVals = argRegs[5];
        for (i = 0; i <= longLocalVals; ++i) {
            callee.longRegs[i] = caller.longRegs[i];
        }
        for (i = 0; i <= doubleLocalVals; ++i) {
            callee.doubleRegs[i] = caller.doubleRegs[i];
        }
        for (i = 0; i <= stringLocalVals; ++i) {
            callee.stringRegs[i] = caller.stringRegs[i];
        }
        for (i = 0; i <= booleanLocalVals; ++i) {
            callee.intRegs[i] = caller.intRegs[i];
        }
        for (i = 0; i <= refLocalVals; ++i) {
            callee.refRegs[i] = caller.refRegs[i];
        }
        for (i = 0; i <= blobLocalVals; ++i) {
            callee.byteRegs[i] = caller.byteRegs[i];
        }
    }

    public static WorkerData createWorkerDataForLocal(WorkerInfo workerInfo, WorkerExecutionContext parentCtx, int[] argRegs, BType[] paramTypes) {
        WorkerData wd = BLangVMUtils.createWorkerData(workerInfo);
        BLangVMUtils.copyArgValues(parentCtx.workerLocal, wd, argRegs, paramTypes);
        return wd;
    }

    static WorkerData createWorkerDataForLocal(WorkerInfo workerInfo, WorkerExecutionContext parentCtx, int[] argRegs) {
        WorkerData wd = BLangVMUtils.createWorkerData(workerInfo);
        BLangVMUtils.copyValuesForForkJoin(parentCtx.workerLocal, wd, argRegs);
        return wd;
    }

    private static WorkerData createWorkerData(WorkerInfo workerInfo) {
        return new WorkerData(workerInfo.getCodeAttributeInfo());
    }

    public static void populateWorkerDataWithValues(WorkerData data, int[] regIndexes, BValue[] vals, BType[] types) {
        if (vals == null) {
            return;
        }
        block7: for (int i = 0; i < vals.length; ++i) {
            int callersRetRegIndex = regIndexes[i];
            BType retType = types[i];
            switch (retType.getTag()) {
                case 1: {
                    if (vals[i] == null) {
                        data.longRegs[callersRetRegIndex] = 0L;
                        continue block7;
                    }
                    data.longRegs[callersRetRegIndex] = ((BInteger)vals[i]).intValue();
                    continue block7;
                }
                case 2: {
                    if (vals[i] == null) {
                        data.doubleRegs[callersRetRegIndex] = 0.0;
                        continue block7;
                    }
                    data.doubleRegs[callersRetRegIndex] = ((BFloat)vals[i]).floatValue();
                    continue block7;
                }
                case 3: {
                    if (vals[i] == null) {
                        data.stringRegs[callersRetRegIndex] = "";
                        continue block7;
                    }
                    data.stringRegs[callersRetRegIndex] = vals[i].stringValue();
                    continue block7;
                }
                case 4: {
                    if (vals[i] == null) {
                        data.intRegs[callersRetRegIndex] = 0;
                        continue block7;
                    }
                    data.intRegs[callersRetRegIndex] = ((BBoolean)vals[i]).booleanValue() ? 1 : 0;
                    continue block7;
                }
                case 5: {
                    if (vals[i] == null) {
                        data.byteRegs[callersRetRegIndex] = new byte[0];
                        continue block7;
                    }
                    data.byteRegs[callersRetRegIndex] = ((BBlob)vals[i]).blobValue();
                    continue block7;
                }
                default: {
                    data.refRegs[callersRetRegIndex] = (BRefType)vals[i];
                }
            }
        }
    }

    public static void populateWorkerResultWithValues(WorkerData result, BValue[] vals, BType[] types) {
        if (vals == null) {
            return;
        }
        int longRegCount = 0;
        int doubleRegCount = 0;
        int stringRegCount = 0;
        int intRegCount = 0;
        int refRegCount = 0;
        int byteRegCount = 0;
        block7: for (int i = 0; i < vals.length; ++i) {
            BType retType = types[i];
            switch (retType.getTag()) {
                case 1: {
                    if (vals[i] == null) {
                        result.longRegs[longRegCount++] = 0L;
                        continue block7;
                    }
                    result.longRegs[longRegCount++] = ((BInteger)vals[i]).intValue();
                    continue block7;
                }
                case 2: {
                    if (vals[i] == null) {
                        result.doubleRegs[doubleRegCount++] = 0.0;
                        continue block7;
                    }
                    result.doubleRegs[doubleRegCount++] = ((BFloat)vals[i]).floatValue();
                    continue block7;
                }
                case 3: {
                    if (vals[i] == null) {
                        result.stringRegs[stringRegCount++] = BLangConstants.STRING_NULL_VALUE;
                        continue block7;
                    }
                    result.stringRegs[stringRegCount++] = vals[i].stringValue();
                    continue block7;
                }
                case 4: {
                    if (vals[i] == null) {
                        result.intRegs[intRegCount++] = 0;
                        continue block7;
                    }
                    result.intRegs[intRegCount++] = ((BBoolean)vals[i]).booleanValue() ? 1 : 0;
                    continue block7;
                }
                case 5: {
                    if (vals[i] == null) {
                        result.byteRegs[byteRegCount++] = new byte[0];
                        continue block7;
                    }
                    result.byteRegs[byteRegCount++] = ((BBlob)vals[i]).blobValue();
                    continue block7;
                }
                default: {
                    result.refRegs[refRegCount++] = (BRefType)vals[i];
                }
            }
        }
    }

    public static BValue[] populateReturnData(WorkerExecutionContext ctx, CallableUnitInfo callableUnitInfo, int[] retRegs) {
        WorkerData data = ctx.workerLocal;
        BType[] retTypes = callableUnitInfo.getRetParamTypes();
        BValue[] returnValues = new BValue[retTypes.length];
        block7: for (int i = 0; i < returnValues.length; ++i) {
            BType retType = retTypes[i];
            switch (retType.getTag()) {
                case 1: {
                    returnValues[i] = new BInteger(data.longRegs[retRegs[i]]);
                    continue block7;
                }
                case 2: {
                    returnValues[i] = new BFloat(data.doubleRegs[retRegs[i]]);
                    continue block7;
                }
                case 3: {
                    returnValues[i] = new BString(data.stringRegs[retRegs[i]]);
                    continue block7;
                }
                case 4: {
                    boolean boolValue = data.intRegs[retRegs[i]] == 1;
                    returnValues[i] = new BBoolean(boolValue);
                    continue block7;
                }
                case 5: {
                    returnValues[i] = new BBlob(data.byteRegs[retRegs[i]]);
                    continue block7;
                }
                default: {
                    returnValues[i] = data.refRegs[retRegs[i]];
                }
            }
        }
        return returnValues;
    }

    public static int[] createReturnRegValues(WorkerDataIndex paramWDI, WorkerDataIndex retWDI, BType[] retTypes) {
        int[] result = new int[retWDI.retRegs.length];
        System.arraycopy(retWDI.retRegs, 0, result, 0, result.length);
        block7: for (int i = 0; i < result.length; ++i) {
            BType retType = retTypes[i];
            switch (retType.getTag()) {
                case 1: {
                    int n = i;
                    result[n] = result[n] + paramWDI.longRegCount;
                    continue block7;
                }
                case 2: {
                    int n = i;
                    result[n] = result[n] + paramWDI.doubleRegCount;
                    continue block7;
                }
                case 3: {
                    int n = i;
                    result[n] = result[n] + paramWDI.stringRegCount;
                    continue block7;
                }
                case 4: {
                    int n = i;
                    result[n] = result[n] + paramWDI.intRegCount;
                    continue block7;
                }
                case 5: {
                    int n = i;
                    result[n] = result[n] + paramWDI.byteRegCount;
                    continue block7;
                }
                default: {
                    int n = i;
                    result[n] = result[n] + paramWDI.refRegCount;
                }
            }
        }
        return result;
    }

    public static int[][] populateArgAndReturnData(WorkerExecutionContext ctx, CallableUnitInfo callableUnitInfo, BValue[] args) {
        WorkerDataIndex wdi1 = callableUnitInfo.paramWorkerIndex;
        WorkerDataIndex wdi2 = callableUnitInfo.retWorkerIndex;
        WorkerData local = BLangVMUtils.createWorkerData(wdi1, wdi2);
        BType[] types = callableUnitInfo.getParamTypes();
        int longParamCount = 0;
        int doubleParamCount = 0;
        int stringParamCount = 0;
        int intParamCount = 0;
        int byteParamCount = 0;
        int refParamCount = 0;
        block7: for (int i = 0; i < types.length; ++i) {
            switch (types[i].getTag()) {
                case 1: {
                    local.longRegs[longParamCount] = args[i] instanceof BString ? ((BString)args[i]).intValue() : ((BInteger)args[i]).intValue();
                    ++longParamCount;
                    continue block7;
                }
                case 2: {
                    local.doubleRegs[doubleParamCount] = args[i] instanceof BString ? ((BString)args[i]).floatValue() : ((BFloat)args[i]).floatValue();
                    ++doubleParamCount;
                    continue block7;
                }
                case 3: {
                    local.stringRegs[stringParamCount] = args[i].stringValue();
                    ++stringParamCount;
                    continue block7;
                }
                case 4: {
                    local.intRegs[intParamCount] = args[i] instanceof BString ? (((BString)args[i]).value().toLowerCase().equals("true") ? 1 : 0) : (((BBoolean)args[i]).booleanValue() ? 1 : 0);
                    ++intParamCount;
                    continue block7;
                }
                case 5: {
                    local.byteRegs[byteParamCount] = ((BBlob)args[i]).blobValue();
                    ++byteParamCount;
                    continue block7;
                }
                default: {
                    local.refRegs[refParamCount] = (BRefType)args[i];
                    ++refParamCount;
                }
            }
        }
        ctx.workerLocal = local;
        return new int[][]{wdi1.retRegs, BLangVMUtils.createReturnRegValues(wdi1, wdi2, callableUnitInfo.getRetParamTypes())};
    }

    public static WorkerData createWorkerData(WorkerDataIndex wdi) {
        return new WorkerData(wdi);
    }

    private static WorkerData createWorkerData(WorkerDataIndex wdi1, WorkerDataIndex wdi2) {
        return new WorkerData(wdi1, wdi2);
    }

    public static void mergeResultData(WorkerData sourceData, WorkerData targetData, BType[] types, int[] regIndexes) {
        int longRegCount = 0;
        int doubleRegCount = 0;
        int stringRegCount = 0;
        int intRegCount = 0;
        int refRegCount = 0;
        int byteRegCount = 0;
        block7: for (int i = 0; i < types.length; ++i) {
            BType retType = types[i];
            int callersRetRegIndex = regIndexes[i];
            switch (retType.getTag()) {
                case 1: {
                    targetData.longRegs[callersRetRegIndex] = sourceData.longRegs[longRegCount++];
                    continue block7;
                }
                case 2: {
                    targetData.doubleRegs[callersRetRegIndex] = sourceData.doubleRegs[doubleRegCount++];
                    continue block7;
                }
                case 3: {
                    targetData.stringRegs[callersRetRegIndex] = sourceData.stringRegs[stringRegCount++];
                    continue block7;
                }
                case 4: {
                    targetData.intRegs[callersRetRegIndex] = sourceData.intRegs[intRegCount++];
                    continue block7;
                }
                case 5: {
                    targetData.byteRegs[callersRetRegIndex] = sourceData.byteRegs[byteRegCount++];
                    continue block7;
                }
                default: {
                    targetData.refRegs[callersRetRegIndex] = sourceData.refRegs[refRegCount++];
                }
            }
        }
    }

    public static void mergeInitWorkertData(WorkerData sourceData, WorkerData targetData, CodeAttributeInfo initWorkerCAI) {
        int i;
        for (i = 0; i < initWorkerCAI.getMaxByteLocalVars(); ++i) {
            targetData.byteRegs[i] = sourceData.byteRegs[i];
        }
        for (i = 0; i < initWorkerCAI.getMaxDoubleLocalVars(); ++i) {
            targetData.doubleRegs[i] = sourceData.doubleRegs[i];
        }
        for (i = 0; i < initWorkerCAI.getMaxIntLocalVars(); ++i) {
            targetData.intRegs[i] = sourceData.intRegs[i];
        }
        for (i = 0; i < initWorkerCAI.getMaxLongLocalVars(); ++i) {
            targetData.longRegs[i] = sourceData.longRegs[i];
        }
        for (i = 0; i < initWorkerCAI.getMaxStringLocalVars(); ++i) {
            targetData.stringRegs[i] = sourceData.stringRegs[i];
        }
        for (i = 0; i < initWorkerCAI.getMaxRefLocalVars(); ++i) {
            targetData.refRegs[i] = sourceData.refRegs[i];
        }
    }

    public static WorkerExecutionContext handleNativeInvocationError(WorkerExecutionContext parentCtx, BStruct error) {
        parentCtx.setError(error);
        try {
            CPU.handleError(parentCtx);
            return parentCtx;
        }
        catch (CPU.HandleErrorException e) {
            if (e.ctx != null && !e.ctx.isRootContext()) {
                return e.ctx;
            }
            return null;
        }
    }

    public static void log(String msg) {
        PrintStream out = System.out;
        out.println(msg);
    }

    public static void setServiceInfo(WorkerExecutionContext ctx, ServiceInfo serviceInfo) {
        ctx.globalProps.put(SERVICE_INFO_KEY, serviceInfo);
    }

    public static ServiceInfo getServiceInfo(WorkerExecutionContext ctx) {
        return (ServiceInfo)ctx.globalProps.get(SERVICE_INFO_KEY);
    }

    public static void setTransactionInfo(WorkerExecutionContext ctx, LocalTransactionInfo localTransactionInfo) {
        ctx.globalProps.put(TRANSACTION_INFO_KEY, localTransactionInfo);
    }

    public static LocalTransactionInfo getTransactionInfo(WorkerExecutionContext ctx) {
        return (LocalTransactionInfo)ctx.globalProps.get(TRANSACTION_INFO_KEY);
    }

    public static void removeTransactionInfo(WorkerExecutionContext ctx) {
        ctx.globalProps.remove(TRANSACTION_INFO_KEY);
    }

    public static void setGlobalTransactionEnabledStatus(WorkerExecutionContext ctx, boolean isGlobalTransactionEnabled) {
        ctx.globalProps.put(GLOBAL_TRANSACTION_ENABLED, isGlobalTransactionEnabled);
    }

    public static boolean getGlobalTransactionenabled(WorkerExecutionContext ctx) {
        return (Boolean)ctx.globalProps.get(GLOBAL_TRANSACTION_ENABLED);
    }
}

