/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.program;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.WorkerInfo;

public class SynchronizedStackFrame
extends StackFrame {
    final Semaphore lock = new Semaphore(0);

    public SynchronizedStackFrame(CallableUnitInfo callableUnitInfo, WorkerInfo workerInfo, int retAddrs, int[] retRegIndexes) {
        super(callableUnitInfo, workerInfo, retAddrs, retRegIndexes);
    }

    @Override
    public void markedAsReturned() {
        super.markedAsReturned();
        this.lock.release();
    }

    public void await() {
        try {
            this.lock.acquire();
            this.lock.release();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean await(int timeout) {
        boolean success = false;
        try {
            success = this.lock.tryAcquire(timeout, TimeUnit.SECONDS);
            if (success) {
                this.lock.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return success;
    }
}

