/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.tracer;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.util.observability.BallerinaObserver;
import org.ballerinalang.util.observability.ObserverContext;
import org.ballerinalang.util.tracer.BSpan;

public class BallerinaTracingObserver
implements BallerinaObserver {
    @Override
    public void startServerObservation(ObserverContext observerContext) {
        BSpan span = new BSpan(observerContext, false);
        span.setConnectorName(observerContext.getServiceName());
        span.setActionName(observerContext.getResourceName());
        Map httpHeaders = (Map)observerContext.getProperty("trace_properties");
        if (httpHeaders != null) {
            httpHeaders.entrySet().stream().filter(c -> "x-b7a-trace".equals(c.getKey())).forEach(e -> span.addProperty((String)e.getKey(), (String)e.getValue()));
        }
        observerContext.addProperty("_span_", span);
        span.startSpan();
    }

    @Override
    public void startClientObservation(ObserverContext observerContext) {
        BSpan activeSpan = new BSpan(observerContext, true);
        observerContext.addProperty("_span_", activeSpan);
        activeSpan.setConnectorName(observerContext.getConnectorName());
        activeSpan.setActionName(observerContext.getActionName());
        observerContext.addProperty("trace_properties", activeSpan.getProperties());
        activeSpan.startSpan();
    }

    @Override
    public void stopServerObservation(ObserverContext observerContext) {
        this.stopObservation(observerContext);
    }

    @Override
    public void stopClientObservation(ObserverContext observerContext) {
        this.stopObservation(observerContext);
    }

    private void stopObservation(ObserverContext observerContext) {
        BSpan span = (BSpan)observerContext.getProperty("_span_");
        if (span != null) {
            Boolean error = (Boolean)observerContext.getProperty("error");
            if (error != null && error.booleanValue()) {
                BStruct bError;
                StringBuilder errorMessageBuilder = new StringBuilder();
                String errorMessage = (String)observerContext.getProperty("error_message");
                if (errorMessage != null) {
                    errorMessageBuilder.append(errorMessage);
                }
                if ((bError = (BStruct)observerContext.getProperty("bstruct_error")) != null) {
                    if (errorMessage != null) {
                        errorMessageBuilder.append('\n');
                    }
                    errorMessageBuilder.append(BLangVMErrors.getPrintableStackTrace(bError));
                }
                HashMap<String, Object> logProps = new HashMap<String, Object>();
                logProps.put("error.kind", "Exception");
                logProps.put("event", "error");
                logProps.put("message", errorMessageBuilder.toString());
                span.logError(logProps);
            }
            span.addTags(observerContext.getTags());
            span.finishSpan();
        }
    }
}

