/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.tracer;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.util.tracer.ReferenceType;
import org.ballerinalang.util.tracer.RequestExtractor;
import org.ballerinalang.util.tracer.RequestInjector;
import org.ballerinalang.util.tracer.SpanStore;
import org.ballerinalang.util.tracer.TracersStore;

public class OpenTracerBallerinaWrapper {
    private static final String DEFAULT_TRACER = "default";
    private static OpenTracerBallerinaWrapper instance = new OpenTracerBallerinaWrapper();
    private TracersStore tracerStore;
    private SpanStore spanStore;
    private final boolean enabled = ConfigRegistry.getInstance().getAsBoolean("b7a.observability.tracing.enabled");

    public OpenTracerBallerinaWrapper() {
        if (this.enabled) {
            this.tracerStore = TracersStore.getInstance();
            this.spanStore = new SpanStore();
        }
    }

    public static OpenTracerBallerinaWrapper getInstance() {
        return instance;
    }

    public Map<String, SpanContext> extract(String encodedHeader) {
        if (this.enabled) {
            HashMap<String, SpanContext> spanContextMap = new HashMap<String, SpanContext>();
            Map<String, Tracer> tracers = this.tracerStore.getTracers(DEFAULT_TRACER);
            boolean hasParent = true;
            for (Map.Entry<String, Tracer> tracerEntry : tracers.entrySet()) {
                spanContextMap.put(tracerEntry.getKey(), tracerEntry.getValue().extract(Format.Builtin.HTTP_HEADERS, (Object)new RequestExtractor(encodedHeader)));
                if (spanContextMap.get(tracerEntry.getKey()) != null) continue;
                hasParent = false;
            }
            if (hasParent) {
                return spanContextMap;
            }
        }
        return Collections.emptyMap();
    }

    public Map<String, String> inject(String suffix, String spanId) {
        if (this.enabled) {
            HashMap<String, String> carrierMap = new HashMap<String, String>();
            Map<String, Span> activeSpanMap = this.spanStore.getSpan(spanId);
            for (Map.Entry<String, Span> activeSpanEntry : activeSpanMap.entrySet()) {
                Map<String, Tracer> tracers = this.tracerStore.getTracers(DEFAULT_TRACER);
                Tracer tracer = tracers.get(activeSpanEntry.getKey());
                if (tracer == null || activeSpanEntry.getValue() == null) continue;
                HashMap<String, String> tracerSpecificCarrier = new HashMap<String, String>();
                RequestInjector requestInjector = new RequestInjector(tracerSpecificCarrier);
                tracer.inject(activeSpanEntry.getValue().context(), Format.Builtin.HTTP_HEADERS, (Object)requestInjector);
                String value = requestInjector.getCarrierString();
                carrierMap.put("x-b7a-utrace-" + suffix, value);
            }
            return carrierMap;
        }
        return Collections.emptyMap();
    }

    public String startSpan(String serviceName, String spanName, Map<String, String> tags, ReferenceType referenceType, String parentSpanId) {
        if (this.enabled) {
            return this.startSpan(serviceName, spanName, tags, referenceType, this.spanStore.getSpanContext(parentSpanId));
        }
        return null;
    }

    public String startSpan(String serviceName, String spanName, Map<String, String> tags, ReferenceType referenceType, Map<String, SpanContext> parentSpanContext) {
        if (this.enabled) {
            HashMap<String, Span> spanMap = new HashMap<String, Span>();
            HashMap<String, SpanContext> spanContextMap = new HashMap<String, SpanContext>();
            Map<String, Tracer> tracers = this.tracerStore.getTracers(serviceName);
            tracers.forEach((tracerName, tracer) -> {
                Tracer.SpanBuilder spanBuilder = tracer.buildSpan(spanName);
                for (Map.Entry tag : tags.entrySet()) {
                    spanBuilder = spanBuilder.withTag((String)tag.getKey(), (String)tag.getValue());
                }
                if (parentSpanContext != null && !parentSpanContext.isEmpty()) {
                    spanBuilder = this.setParent(referenceType, parentSpanContext, spanBuilder, (String)tracerName);
                }
                Span span = spanBuilder.start();
                spanMap.put((String)tracerName, span);
                spanContextMap.put((String)tracerName, span.context());
            });
            String spanId = UUID.randomUUID().toString();
            this.spanStore.addSpan(spanId, spanMap);
            this.spanStore.addSpanContext(spanId, spanContextMap);
            return spanId;
        }
        return null;
    }

    private Tracer.SpanBuilder setParent(ReferenceType referenceType, Map<String, SpanContext> parentSpanContext, Tracer.SpanBuilder spanBuilder, String tracerName) {
        SpanContext parentSpan = parentSpanContext.get(tracerName);
        if (parentSpan != null) {
            if (ReferenceType.CHILDOF == referenceType) {
                spanBuilder = spanBuilder.asChildOf(parentSpan);
            } else if (ReferenceType.FOLLOWSFROM == referenceType) {
                spanBuilder.addReference("follows_from", parentSpan);
            }
        }
        return spanBuilder;
    }

    public void finishSpan(String spanId) {
        Map<String, Span> spanMap;
        if (this.enabled && (spanMap = this.spanStore.closeSpan(spanId)) != null) {
            spanMap.forEach((tracerName, span) -> span.finish());
        }
    }

    public void addTags(String spanId, String tagKey, String tagValue) {
        Map<String, Span> spanList;
        if (this.enabled && (spanList = this.spanStore.getSpan(spanId)) != null) {
            spanList.forEach((tracerName, span) -> span.setTag(tagKey, tagValue));
        }
    }

    public void log(String spanId, Map<String, String> logs) {
        if (this.enabled) {
            Map<String, Span> spanList = this.spanStore.getSpan(spanId);
            spanList.forEach((tracerName, span) -> span.log(logs));
        }
    }

    public void setBaggageItem(String spanId, String baggageKey, String baggageValue) {
        if (this.enabled) {
            Map<String, Span> spanList = this.spanStore.getSpan(spanId);
            spanList.forEach((tracerName, span) -> span.setBaggageItem(baggageKey, baggageValue));
        }
    }

    public String getBaggageItem(String spanId, String baggageKey) {
        String baggageValue;
        block1: {
            Map.Entry<String, Span> spanEntry;
            baggageValue = null;
            if (!this.enabled) break block1;
            Map<String, Span> spanMap = this.spanStore.getSpan(spanId);
            Iterator<Map.Entry<String, Span>> iterator = spanMap.entrySet().iterator();
            while (iterator.hasNext() && (baggageValue = (spanEntry = iterator.next()).getValue().getBaggageItem(baggageKey)) == null) {
            }
        }
        return baggageValue;
    }
}

