/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.tracer;

import io.opentracing.Tracer;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.util.tracer.OpenTracer;
import org.ballerinalang.util.tracer.exception.InvalidConfigurationException;

class TracersStore {
    private List<TracerGenerator> tracers;
    private Map<String, Map<String, Tracer>> tracerStore;
    private static final PrintStream consoleError = System.err;
    private static TracersStore instance = new TracersStore();

    public static TracersStore getInstance() {
        return instance;
    }

    private TracersStore() {
    }

    public void loadTracers() {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        if (configRegistry.getAsBoolean("b7a.observability.tracing.enabled")) {
            this.tracers = new ArrayList<TracerGenerator>();
            this.tracerStore = new HashMap<String, Map<String, Tracer>>();
            ServiceLoader<OpenTracer> openTracers = ServiceLoader.load(OpenTracer.class);
            HashMap tracerMap = new HashMap();
            openTracers.forEach(t -> tracerMap.put(t.getName().toLowerCase(), t));
            String tracerName = configRegistry.getConfigOrDefault("b7a.observability.tracing.name", "jaeger");
            OpenTracer tracer = (OpenTracer)tracerMap.get(tracerName.toLowerCase());
            if (tracer != null) {
                try {
                    tracer.init();
                    this.tracers.add(new TracerGenerator(tracer.getName(), tracer));
                }
                catch (InvalidConfigurationException e) {
                    consoleError.println("ballerina: error in observability tracing configurations: " + e.getMessage());
                }
            } else {
                consoleError.println("ballerina: observability enabled but no tracing extension found for name " + tracerName);
            }
        } else {
            this.tracers = Collections.emptyList();
            this.tracerStore = new HashMap<String, Map<String, Tracer>>();
        }
    }

    Map<String, Tracer> getTracers(String serviceName) {
        if (this.tracerStore.containsKey(serviceName)) {
            return this.tracerStore.get(serviceName);
        }
        HashMap<String, Tracer> tracerMap = new HashMap<String, Tracer>();
        for (TracerGenerator tracerGenerator : this.tracers) {
            try {
                Tracer tracer = tracerGenerator.generate(serviceName);
                tracerMap.put(tracerGenerator.name, tracer);
            }
            catch (Throwable e) {
                consoleError.println("ballerina: error getting tracer for " + tracerGenerator.name + ". " + e.getMessage());
            }
        }
        this.tracerStore.put(serviceName, tracerMap);
        return tracerMap;
    }

    private static class TracerGenerator {
        String name;
        OpenTracer tracer;

        TracerGenerator(String name, OpenTracer tracer) {
            this.name = name;
            this.tracer = tracer;
        }

        Tracer generate(String serviceName) {
            return this.tracer.getTracer(this.name, serviceName);
        }
    }
}

