/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.transactions;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.util.transactions.BallerinaTransactionContext;
import org.ballerinalang.util.transactions.TransactionResourceManager;
import org.ballerinalang.util.transactions.TransactionUtils;

public class LocalTransactionInfo {
    private String globalTransactionId;
    private String url;
    private String protocol;
    private int transactionLevel;
    private Map<Integer, Integer> allowedTransactionRetryCounts;
    private Map<Integer, Integer> currentTransactionRetryCounts;
    private Map<String, BallerinaTransactionContext> transactionContextStore;
    private Stack<Integer> transactionBlockIdStack;

    public LocalTransactionInfo(String globalTransactionId, String url, String protocol) {
        this.globalTransactionId = globalTransactionId;
        this.url = url;
        this.protocol = protocol;
        this.transactionLevel = 0;
        this.allowedTransactionRetryCounts = new HashMap<Integer, Integer>();
        this.currentTransactionRetryCounts = new HashMap<Integer, Integer>();
        this.transactionContextStore = new HashMap<String, BallerinaTransactionContext>();
        this.transactionBlockIdStack = new Stack();
    }

    public String getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public int getCurrentTransactionBlockId() {
        return this.transactionBlockIdStack.peek();
    }

    public boolean hasTransactionBlock() {
        return !this.transactionBlockIdStack.empty();
    }

    public String getURL() {
        return this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void beginTransactionBlock(int localTransactionID, int retryCount) {
        this.transactionBlockIdStack.push(localTransactionID);
        this.allowedTransactionRetryCounts.put(localTransactionID, retryCount);
        this.currentTransactionRetryCounts.put(localTransactionID, 0);
        ++this.transactionLevel;
    }

    public void incrementCurrentRetryCount(int localTransactionID) {
        int count = this.currentTransactionRetryCounts.containsKey(localTransactionID) ? this.currentTransactionRetryCounts.get(localTransactionID) : 0;
        this.currentTransactionRetryCounts.put(localTransactionID, count + 1);
    }

    public BallerinaTransactionContext getTransactionContext(String connectorid) {
        return this.transactionContextStore.get(connectorid);
    }

    public void registerTransactionContext(String connectorid, BallerinaTransactionContext txContext) {
        this.transactionContextStore.put(connectorid, txContext);
    }

    public boolean isRetryPossible(WorkerExecutionContext context, int transactionId) {
        int allowedRetryCount = this.getAllowedRetryCount(transactionId);
        int currentRetryCount = this.getCurrentRetryCount(transactionId);
        if (currentRetryCount >= allowedRetryCount && currentRetryCount != 0) {
            return false;
        }
        boolean isGlobalTransactionEnabled = context.getGlobalTransactionEnabled();
        if (!isGlobalTransactionEnabled) {
            return true;
        }
        return currentRetryCount == 0 || TransactionUtils.isInitiator(context, this.globalTransactionId, transactionId);
    }

    public boolean onTransactionFailed(WorkerExecutionContext context, int transactionBlockId) {
        boolean bNotifyCoordinator = false;
        if (this.isRetryPossible(context, transactionBlockId)) {
            this.transactionContextStore.clear();
            TransactionResourceManager.getInstance().rollbackTransaction(this.globalTransactionId, transactionBlockId);
        } else {
            bNotifyCoordinator = true;
        }
        return bNotifyCoordinator;
    }

    public boolean onTransactionEnd(int transactionBlockId) {
        boolean isOuterTx = false;
        this.transactionBlockIdStack.pop();
        --this.transactionLevel;
        if (this.transactionLevel == 0) {
            TransactionResourceManager.getInstance().endXATransaction(this.globalTransactionId, transactionBlockId);
            this.resetTransactionInfo();
            isOuterTx = true;
        }
        return isOuterTx;
    }

    private int getAllowedRetryCount(int localTransactionID) {
        return this.allowedTransactionRetryCounts.get(localTransactionID);
    }

    private int getCurrentRetryCount(int localTransactionID) {
        return this.currentTransactionRetryCounts.get(localTransactionID);
    }

    private void resetTransactionInfo() {
        this.allowedTransactionRetryCounts.clear();
        this.currentTransactionRetryCounts.clear();
        this.transactionContextStore.clear();
    }
}

