/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.transactions;

import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.program.BLangFunctions;

public class TransactionUtils {
    public static BValue[] notifyTransactionBegin(WorkerExecutionContext ctx, String globalTransactionId, String url, int transactionBlockId, String protocol) {
        BValue[] args = new BValue[]{globalTransactionId == null ? null : new BString(globalTransactionId), new BInteger(transactionBlockId), new BString(url), new BString(protocol)};
        BValue[] returns = TransactionUtils.invokeCoordinatorFunction(ctx, "beginTransaction", args);
        TransactionUtils.checkTransactionCoordinatorError(returns[0], ctx, "error in transaction start: ");
        return returns;
    }

    public static void notifyTransactionEnd(WorkerExecutionContext ctx, String globalTransactionId, int transactionBlockId) {
        BValue[] args = new BValue[]{new BString(globalTransactionId), new BInteger(transactionBlockId)};
        BValue[] returns = TransactionUtils.invokeCoordinatorFunction(ctx, "endTransaction", args);
        TransactionUtils.checkTransactionCoordinatorError(returns[0], ctx, "error in transaction end: ");
    }

    public static void notifyTransactionAbort(WorkerExecutionContext ctx, String globalTransactionId, int transactionBlockId) {
        BValue[] args = new BValue[]{new BString(globalTransactionId), new BInteger(transactionBlockId)};
        TransactionUtils.invokeCoordinatorFunction(ctx, "abortTransaction", args);
    }

    public static boolean isInitiator(WorkerExecutionContext ctx, String globalTransactionId, int transactionBlockId) {
        BValue[] args = new BValue[]{new BString(globalTransactionId), new BInteger(transactionBlockId)};
        BValue[] returns = TransactionUtils.invokeCoordinatorFunction(ctx, "isInitiator", args);
        return ((BBoolean)returns[0]).booleanValue();
    }

    private static void checkTransactionCoordinatorError(BValue value, WorkerExecutionContext ctx, String errMsg) {
        PackageInfo errorPackageInfo;
        StructInfo errorStructInfo;
        if (value.getType().getTag() == 15 && ((BStruct)value).getType().structInfo.equals(errorStructInfo = (errorPackageInfo = ctx.programFile.getPackageInfo("ballerina.builtin")).getStructInfo("error"))) {
            throw new BallerinaException(errMsg + ((BStruct)value).getStringField(0));
        }
    }

    private static BValue[] invokeCoordinatorFunction(WorkerExecutionContext ctx, String functionName, BValue[] args) {
        PackageInfo packageInfo = ctx.programFile.getPackageInfo("ballerina.transactions");
        FunctionInfo functionInfo = packageInfo.getFunctionInfo(functionName);
        return BLangFunctions.invokeCallable((CallableUnitInfo)functionInfo, args);
    }
}

