/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.filepath.nativeimpl;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.regex.PatternSyntaxException;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.filepath.Utils;

@BallerinaFunction(orgName="ballerina", packageName="filepath", functionName="matches", isPublic=true)
public class Matches {
    private static final String GLOB_SYNTAX_FLAVOR = "glob:";

    public static Object matches(Strand strand, String inputPath, String pattern) {
        PathMatcher matcher;
        FileSystem fs = FileSystems.getDefault();
        try {
            matcher = !pattern.startsWith(GLOB_SYNTAX_FLAVOR) ? fs.getPathMatcher(GLOB_SYNTAX_FLAVOR + pattern) : fs.getPathMatcher(pattern);
        }
        catch (PatternSyntaxException ex) {
            return Utils.getPathError("{ballerina/filepath}InvalidPatternError", "Invalid pattern " + pattern);
        }
        if (inputPath == null) {
            return false;
        }
        return matcher.matches(Paths.get(inputPath, new String[0]));
    }
}

