/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.filepath.nativeimpl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.filepath.Utils;

@BallerinaFunction(orgName="ballerina", packageName="filepath", functionName="resolve", isPublic=true)
public class Resolve {
    public static Object resolve(Strand strand, String inputPath) {
        try {
            Path realPath = Files.readSymbolicLink(Paths.get(inputPath, new String[0]).toAbsolutePath());
            return realPath.toString();
        }
        catch (NotLinkException ex) {
            return Utils.getPathError("{ballerina/filepath}NotLinkError", "Path is not a symbolic link " + inputPath);
        }
        catch (NoSuchFileException ex) {
            return Utils.getPathError("{ballerina/filepath}FileNotFoundError", "File does not exist at " + inputPath);
        }
        catch (IOException ex) {
            return Utils.getPathError("{ballerina/filepath}IOError", "IO error for " + inputPath);
        }
        catch (SecurityException ex) {
            return Utils.getPathError("{ballerina/filepath}SecurityError", "Security error for " + inputPath);
        }
    }
}

