/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.jsonutils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLText;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BXML;

public class XmlToJsonConverter {
    private static final String XML_NAMESPACE_PREFIX_FRAGMENT = "xmlns:";
    private static final BType jsonMapType = new BMapType("map", BTypes.typeJSON, new BPackage(null, null, null));
    private static final String XMLNS = "xmlns";

    public static Object convertToJSON(XMLValue xml, String attributePrefix, boolean preserveNamespaces) {
        if (xml instanceof XMLText) {
            return JSONParser.parse((String)("\"" + ((XMLText)xml).stringValue() + "\""));
        }
        if (xml instanceof XMLItem) {
            return XmlToJsonConverter.convertElement((XMLItem)xml, attributePrefix, preserveNamespaces);
        }
        if (xml instanceof XMLSequence) {
            XMLSequence xmlSequence = (XMLSequence)xml;
            if (xmlSequence.isEmpty()) {
                return XmlToJsonConverter.newJsonList();
            }
            Object seq = XmlToJsonConverter.convertXMLSequence(xmlSequence, attributePrefix, preserveNamespaces);
            if (seq == null) {
                return XmlToJsonConverter.newJsonList();
            }
            return seq;
        }
        return XmlToJsonConverter.newJsonMap();
    }

    private static Object convertElement(XMLItem xmlItem, String attributePrefix, boolean preserveNamespaces) {
        MapValueImpl<String, Object> rootNode = XmlToJsonConverter.newJsonMap();
        LinkedHashMap<String, String> attributeMap = XmlToJsonConverter.collectAttributesAndNamespaces(xmlItem, preserveNamespaces);
        String keyValue = XmlToJsonConverter.getElementKey(xmlItem, preserveNamespaces);
        Object children = XmlToJsonConverter.convertXMLSequence(xmlItem.getChildrenSeq(), attributePrefix, preserveNamespaces);
        if (attributeMap.isEmpty() && children == null) {
            rootNode.put((Object)keyValue, (Object)"");
            return rootNode;
        }
        if (children != null) {
            rootNode.put((Object)keyValue, children);
        }
        if (!attributeMap.isEmpty()) {
            XmlToJsonConverter.addAttributes(rootNode, attributePrefix, attributeMap);
        }
        return rootNode;
    }

    private static void addAttributes(MapValueImpl<String, Object> rootNode, String attributePrefix, LinkedHashMap<String, String> attributeMap) {
        for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
            rootNode.put((Object)(attributePrefix + entry.getKey()), (Object)entry.getValue());
        }
    }

    private static Object convertXMLSequence(XMLSequence xmlSequence, String attributePrefix, boolean preserveNamespaces) {
        List sequence = xmlSequence.getChildrenList();
        if (sequence.isEmpty()) {
            return null;
        }
        switch (XmlToJsonConverter.calculateMatchingJsonTypeForSequence(sequence)) {
            case SAME_KEY: {
                return XmlToJsonConverter.convertSequenceWithSameNamedElements(attributePrefix, preserveNamespaces, sequence);
            }
            case ELEMENT_ONLY: {
                return XmlToJsonConverter.convertSequenceWithOnlyElements(attributePrefix, preserveNamespaces, sequence);
            }
        }
        return XmlToJsonConverter.convertHeterogeneousSequence(attributePrefix, preserveNamespaces, sequence);
    }

    private static Object convertHeterogeneousSequence(String attributePrefix, boolean preserveNamespaces, List<BXML> sequence) {
        if (sequence.size() == 1) {
            return XmlToJsonConverter.convertToJSON((XMLValue)sequence.get(0), attributePrefix, preserveNamespaces);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (BXML bxml : sequence) {
            if (XmlToJsonConverter.isCommentOrPi(bxml)) continue;
            list.add(XmlToJsonConverter.convertToJSON((XMLValue)bxml, attributePrefix, preserveNamespaces));
        }
        if (list.isEmpty()) {
            return null;
        }
        return XmlToJsonConverter.newJsonListFrom(list);
    }

    private static Object convertSequenceWithOnlyElements(String attributePrefix, boolean preserveNamespaces, List<BXML> sequence) {
        MapValueImpl<String, Object> elementObj = XmlToJsonConverter.newJsonMap();
        for (BXML bxml : sequence) {
            Object val;
            MapValueImpl mapVal;
            if (XmlToJsonConverter.isCommentOrPi(bxml)) continue;
            String elementName = XmlToJsonConverter.getElementKey((XMLItem)bxml, preserveNamespaces);
            Object elemAsJson = XmlToJsonConverter.convertElement((XMLItem)bxml, attributePrefix, preserveNamespaces);
            if (elemAsJson instanceof MapValueImpl && (mapVal = (MapValueImpl)elemAsJson).size() == 1 && (val = mapVal.get((Object)elementName)) != null) {
                elementObj.put((Object)elementName, val);
                continue;
            }
            elementObj.put((Object)elementName, elemAsJson);
        }
        return elementObj;
    }

    private static boolean isCommentOrPi(BXML bxml) {
        return bxml.getNodeType() == XMLNodeType.COMMENT || bxml.getNodeType() == XMLNodeType.PI;
    }

    private static Object convertSequenceWithSameNamedElements(String attributePrefix, boolean preserveNamespaces, List<BXML> sequence) {
        String elementName = null;
        for (BXML bxml : sequence) {
            if (bxml.getNodeType() != XMLNodeType.ELEMENT) continue;
            elementName = bxml.getElementName();
            break;
        }
        MapValueImpl<String, Object> listWrapper = XmlToJsonConverter.newJsonMap();
        ArrayValueImpl arrayValue = XmlToJsonConverter.convertChildrenToJsonList(sequence, attributePrefix, preserveNamespaces);
        listWrapper.put((Object)elementName, (Object)arrayValue);
        return listWrapper;
    }

    private static ArrayValueImpl convertChildrenToJsonList(List<BXML> sequence, String prefix, boolean preserveNamespaces) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (BXML child : sequence) {
            if (XmlToJsonConverter.isCommentOrPi(child)) continue;
            if (child.getAttributesMap().isEmpty()) {
                list.add(XmlToJsonConverter.convertToJSON((XMLValue)child.children(), prefix, preserveNamespaces));
                continue;
            }
            list.add(XmlToJsonConverter.convertElement((XMLItem)child, prefix, preserveNamespaces));
        }
        return XmlToJsonConverter.newJsonListFrom(list);
    }

    private static SequenceConvertibility calculateMatchingJsonTypeForSequence(List<BXML> sequence) {
        Iterator<BXML> iterator = sequence.iterator();
        BXML next = iterator.next();
        if (next.getNodeType() == XMLNodeType.TEXT) {
            return SequenceConvertibility.LIST;
        }
        while (iterator.hasNext() && XmlToJsonConverter.isCommentOrPi(next)) {
            next = iterator.next();
            if (next.getNodeType() != XMLNodeType.TEXT) continue;
            return SequenceConvertibility.LIST;
        }
        String firstElementName = next.getElementName();
        int i = 0;
        boolean sameElementName = true;
        while (iterator.hasNext()) {
            BXML val = iterator.next();
            if (val.getNodeType() == XMLNodeType.ELEMENT) {
                if (!((XMLItem)val).getElementName().equals(firstElementName)) {
                    sameElementName = false;
                }
            } else {
                if (val.getNodeType() == XMLNodeType.TEXT) {
                    return SequenceConvertibility.LIST;
                }
                --i;
            }
            ++i;
        }
        return sameElementName && i > 0 ? SequenceConvertibility.SAME_KEY : SequenceConvertibility.ELEMENT_ONLY;
    }

    private static ArrayValueImpl newJsonList() {
        return new ArrayValueImpl(new BArrayType(BTypes.typeJSON));
    }

    public static ArrayValueImpl newJsonListFrom(List<Object> items) {
        return new ArrayValueImpl(items.toArray(), new BArrayType(BTypes.typeJSON));
    }

    private static MapValueImpl<String, Object> newJsonMap() {
        return new MapValueImpl(jsonMapType);
    }

    private static LinkedHashMap<String, String> collectAttributesAndNamespaces(XMLItem element, boolean preserveNamespaces) {
        int nsPrefixBeginIndex = "{http://www.w3.org/2000/xmlns/}".length();
        LinkedHashMap<String, String> attributeMap = new LinkedHashMap<String, String>();
        HashMap<String, String> nsPrefixMap = new HashMap<String, String>();
        for (Map.Entry entry : element.getAttributesMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith("{http://www.w3.org/2000/xmlns/}")) continue;
            String prefix = ((String)entry.getKey()).substring(nsPrefixBeginIndex);
            String ns = (String)entry.getValue();
            nsPrefixMap.put(ns, prefix);
            if (!preserveNamespaces) continue;
            if (prefix.equals(XMLNS)) {
                attributeMap.put(prefix, ns);
                continue;
            }
            attributeMap.put(XML_NAMESPACE_PREFIX_FRAGMENT + prefix, ns);
        }
        for (Map.Entry entry : element.getAttributesMap().entrySet()) {
            String key = (String)entry.getKey();
            if (preserveNamespaces && !key.startsWith("{http://www.w3.org/2000/xmlns/}")) {
                int nsEndIndex = key.lastIndexOf(125);
                if (nsEndIndex > 0) {
                    String ns = key.substring(1, nsEndIndex);
                    String local = key.substring(nsEndIndex + 1);
                    String nsPrefix = (String)nsPrefixMap.get(ns);
                    if (nsPrefix != null && !nsPrefix.equals(XMLNS)) {
                        attributeMap.put(nsPrefix + ":" + local, (String)entry.getValue());
                        continue;
                    }
                    attributeMap.put(local, (String)entry.getValue());
                    continue;
                }
                attributeMap.put(key, (String)entry.getValue());
                continue;
            }
            String attrName = (String)entry.getKey();
            int endOfBrace = attrName.indexOf(125);
            if (endOfBrace > 0) {
                String localName = attrName.substring(endOfBrace + 1);
                if (localName.equals(XMLNS)) continue;
                attributeMap.put(localName, (String)entry.getValue());
                continue;
            }
            attributeMap.put(attrName, (String)entry.getValue());
        }
        return attributeMap;
    }

    private static String getElementKey(XMLItem xmlItem, boolean preserveNamespaces) {
        String prefix;
        StringBuilder elementKey = new StringBuilder();
        QName qName = xmlItem.getQName();
        if (preserveNamespaces && (prefix = qName.getPrefix()) != null && !prefix.isEmpty()) {
            elementKey.append(prefix).append(':');
        }
        elementKey.append(qName.getLocalPart());
        return elementKey.toString();
    }

    private static enum SequenceConvertibility {
        SAME_KEY,
        ELEMENT_ONLY,
        LIST;

    }
}

