/*
*  Copyright (c) 2018, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
*
*  WSO2 Inc. licenses this file to you under the Apache License,
*  Version 2.0 (the "License"); you may not use this file except
*  in compliance with the License.
*  You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing,
*  software distributed under the License is distributed on an
*  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
*  KIND, either express or implied.  See the License for the
*  specific language governing permissions and limitations
*  under the License.
*/

package org.ballerinalang.mime.util;

import org.ballerinalang.nativeimpl.io.BallerinaIOException;
import org.jvnet.mimepull.MIMEPart;

import java.io.IOException;

/**
 * Wrap body part stream as a ballerina specific byte channel. A reference has been kept for 'MIMEPart' for temp file
 * deletion purpose.
 *
 * @since 0.964.0
 */
public class MimeEntityWrapper extends EntityWrapper {

    private MIMEPart mimePart;

    MimeEntityWrapper(EntityBodyChannel channel, MIMEPart mimePart) throws BallerinaIOException {
        super(channel);
        this.mimePart = mimePart;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (mimePart != null) {
            mimePart.close(); //Clean up temp files
        }
    }
}
