/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.runtime.message.MessageDataSource;
import org.ballerinalang.runtime.message.StringDataSource;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getBodyAsString", receiver=@Receiver(type=TypeKind.STRUCT, structType="Entity", structPackage="ballerina.mime"), returnType={@ReturnType(type=TypeKind.STRING), @ReturnType(type=TypeKind.STRUCT)}, isPublic=true)
public class GetBodyAsString
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        try {
            BString result;
            BStruct entityStruct = (BStruct)context.getRefArgument(0);
            MessageDataSource dataSource = EntityBodyHandler.getMessageDataSource(entityStruct);
            if (dataSource != null) {
                result = new BString(dataSource.getMessageAsString());
            } else {
                StringDataSource stringDataSource = EntityBodyHandler.constructStringDataSource(entityStruct);
                result = new BString(stringDataSource.getMessageAsString());
                EntityBodyHandler.addMessageDataSource(entityStruct, (MessageDataSource)stringDataSource);
                entityStruct.addNativeData("entity_byte_channel", null);
            }
            context.setReturnValues(new BValue[]{result});
        }
        catch (Throwable e) {
            context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Error occurred while retrieving text data from entity : " + e.getMessage())});
        }
    }
}

