/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import java.util.Locale;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.io.channels.base.Channel;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getBodyParts", receiver=@Receiver(type=TypeKind.STRUCT, structType="Entity", structPackage="ballerina.mime"), returnType={@ReturnType(type=TypeKind.ARRAY), @ReturnType(type=TypeKind.STRUCT)}, isPublic=true)
public class GetBodyParts
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        try {
            BStruct entityStruct = (BStruct)context.getRefArgument(0);
            String baseType = HeaderUtil.getBaseType(entityStruct);
            if (baseType != null && (baseType.toLowerCase(Locale.getDefault()).startsWith("multipart/") || baseType.toLowerCase(Locale.getDefault()).startsWith("message/"))) {
                Channel byteChannel;
                BRefValueArray partsArray = EntityBodyHandler.getBodyPartArray(entityStruct);
                if ((partsArray == null || partsArray.size() < 1L) && (byteChannel = EntityBodyHandler.getByteChannel(entityStruct)) != null) {
                    EntityBodyHandler.decodeEntityBody(context, entityStruct, byteChannel);
                    partsArray = EntityBodyHandler.getBodyPartArray(entityStruct);
                    entityStruct.addNativeData("entity_byte_channel", null);
                }
                context.setReturnValues(new BValue[]{partsArray});
            } else {
                context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Entity body is not a type of composite media type. Received content-type : " + baseType)});
            }
        }
        catch (Throwable e) {
            context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Error occurred while extracting body parts from entity: " + e.getMessage())});
        }
    }
}

