/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import java.util.Locale;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.util.XMLUtils;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.runtime.message.MessageDataSource;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getXml", receiver=@Receiver(type=TypeKind.STRUCT, structType="Entity", structPackage="ballerina.mime"), returnType={@ReturnType(type=TypeKind.XML), @ReturnType(type=TypeKind.STRUCT)}, isPublic=true)
public class GetXml
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        try {
            BStruct entityStruct = (BStruct)context.getRefArgument(0);
            String baseType = HeaderUtil.getBaseType(entityStruct);
            if (baseType != null && (baseType.toLowerCase(Locale.getDefault()).endsWith("/xml") || baseType.toLowerCase(Locale.getDefault()).endsWith("+xml"))) {
                BXML result;
                MessageDataSource dataSource = EntityBodyHandler.getMessageDataSource(entityStruct);
                if (dataSource != null) {
                    result = dataSource instanceof BXML ? (BXML)dataSource : XMLUtils.parse((String)dataSource.getMessageAsString());
                } else {
                    result = EntityBodyHandler.constructXmlDataSource(entityStruct);
                    EntityBodyHandler.addMessageDataSource(entityStruct, (MessageDataSource)result);
                    entityStruct.addNativeData("entity_byte_channel", null);
                }
                context.setReturnValues(new BValue[]{result});
            } else {
                context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Entity body is not xml compatible since the received content-type is : " + baseType)});
            }
        }
        catch (Throwable e) {
            context.setReturnValues(new BValue[]{MimeUtil.createEntityError(context, "Error occurred while retrieving xml data from entity : " + e.getMessage())});
        }
    }
}

