/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.FullHttpMessageListener;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public abstract class AbstractGetPayloadHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractGetPayloadHandler.class);

    public static void constructNonBlockingDataSource(final NonBlockingCallback callback, final ObjectValue entity, final SourceType sourceType) {
        HttpCarbonMessage inboundMessage = AbstractGetPayloadHandler.extractTransportMessageFromEntity(entity);
        inboundMessage.getFullHttpCarbonMessage().addListener(new FullHttpMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(HttpCarbonMessage inboundMessage) {
                Object dataSource = null;
                HttpMessageDataStreamer dataStreamer = new HttpMessageDataStreamer(inboundMessage);
                InputStream inputStream = dataStreamer.getInputStream();
                try {
                    switch (sourceType) {
                        case JSON: {
                            dataSource = EntityBodyHandler.constructJsonDataSource(entity, inputStream);
                            AbstractGetPayloadHandler.updateJsonDataSourceAndNotify(callback, entity, dataSource);
                            return;
                        }
                        case TEXT: {
                            dataSource = EntityBodyHandler.constructStringDataSource(entity, inputStream);
                            break;
                        }
                        case XML: {
                            dataSource = EntityBodyHandler.constructXmlDataSource(entity, inputStream);
                            break;
                        }
                        case BLOB: {
                            dataSource = EntityBodyHandler.constructBlobDataSource(inputStream);
                        }
                    }
                    AbstractGetPayloadHandler.updateDataSourceAndNotify(callback, entity, dataSource);
                }
                catch (Exception e) {
                    AbstractGetPayloadHandler.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting " + sourceType.toString().toLowerCase(Locale.ENGLISH) + " data from entity: " + AbstractGetPayloadHandler.getErrorMsg(e), null);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        log.error("Error occurred while closing the inbound data stream", (Throwable)ex);
                    }
                }
            }

            public void onError(Exception ex) {
                AbstractGetPayloadHandler.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting content from message : " + ex.getMessage(), null);
            }
        });
    }

    private static void setReturnValuesAndNotify(NonBlockingCallback callback, Object result) {
        callback.setReturnValues(result);
        callback.notifySuccess();
    }

    static Object createParsingEntityBodyFailedErrorAndNotify(NonBlockingCallback callback, String errMsg, ErrorValue errorValue) {
        ErrorValue error = MimeUtil.createError("ParserError", errMsg, errorValue);
        return AbstractGetPayloadHandler.returnErrorValue(callback, error);
    }

    private static Object returnErrorValue(NonBlockingCallback callback, Object err) {
        if (callback != null) {
            AbstractGetPayloadHandler.setReturnValuesAndNotify(callback, err);
            return null;
        }
        return err;
    }

    static String getErrorMsg(Throwable err) {
        return err instanceof ErrorValue ? err.toString() : err.getMessage();
    }

    static void updateDataSource(ObjectValue entityObj, Object result) {
        EntityBodyHandler.addMessageDataSource(entityObj, result);
        AbstractGetPayloadHandler.removeByteChannel(entityObj);
    }

    static void updateJsonDataSource(ObjectValue entityObj, Object result) {
        EntityBodyHandler.addJsonMessageDataSource(entityObj, result);
        AbstractGetPayloadHandler.removeByteChannel(entityObj);
    }

    private static void removeByteChannel(ObjectValue entityObj) {
        entityObj.addNativeData("entity_byte_channel", null);
    }

    private static void updateDataSourceAndNotify(NonBlockingCallback callback, ObjectValue entityObj, Object result) {
        AbstractGetPayloadHandler.updateDataSource(entityObj, result);
        AbstractGetPayloadHandler.setReturnValuesAndNotify(callback, result);
    }

    private static void updateJsonDataSourceAndNotify(NonBlockingCallback callback, ObjectValue entityObj, Object result) {
        AbstractGetPayloadHandler.updateJsonDataSource(entityObj, result);
        AbstractGetPayloadHandler.setReturnValuesAndNotify(callback, result);
    }

    private static HttpCarbonMessage extractTransportMessageFromEntity(ObjectValue entityObj) {
        HttpCarbonMessage message = (HttpCarbonMessage)entityObj.getNativeData("transport_message");
        if (message != null) {
            return message;
        }
        throw MimeUtil.createError("NoContentError", "Empty content");
    }

    public static enum SourceType {
        JSON,
        XML,
        TEXT,
        BLOB;

    }
}

