/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.List;
import java.util.TreeSet;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.mime.util.MimeUtil;

public class EntityHeaders {
    private static final BArrayType bArrayType = new BArrayType(BTypes.typeHandle);

    public static void addHeader(ObjectValue entityObj, BString headerName, BString headerValue, Object position) {
        if (headerName == null || headerValue == null) {
            return;
        }
        try {
            EntityHeaders.getOrCreateHeadersBasedOnPosition(entityObj, position).add(headerName.getValue(), (Object)headerValue.getValue());
        }
        catch (IllegalArgumentException ex) {
            throw MimeUtil.createError("InvalidHeaderOperationError", ex.getMessage());
        }
    }

    public static BString getHeader(ObjectValue entityObj, BString headerName, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders == null) {
            throw MimeUtil.createError("HeaderNotFoundError", "Http header does not exist");
        }
        if (httpHeaders.get(headerName.getValue()) != null) {
            return StringUtils.fromString((String)httpHeaders.get(headerName.getValue()));
        }
        throw MimeUtil.createError("HeaderNotFoundError", "Http header does not exist");
    }

    public static ArrayValue getHeaderNames(ObjectValue entityObj, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders == null || httpHeaders.isEmpty()) {
            return new ArrayValueImpl(new BString[0]);
        }
        TreeSet distinctNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        distinctNames.addAll(httpHeaders.names());
        return new ArrayValueImpl(StringUtils.fromStringArray((String[])distinctNames.toArray(new String[0])));
    }

    public static ArrayValue getHeaders(ObjectValue entityObj, BString headerName, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders == null) {
            throw MimeUtil.createError("HeaderNotFoundError", "Http header does not exist");
        }
        List headerValueList = httpHeaders.getAll(headerName.getValue());
        if (headerValueList == null) {
            throw MimeUtil.createError("HeaderNotFoundError", "Http header does not exist");
        }
        return new ArrayValueImpl(StringUtils.fromStringArray((String[])headerValueList.toArray(new String[0])));
    }

    public static boolean hasHeader(ObjectValue entityObj, BString headerName, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders == null) {
            return false;
        }
        List headerValueList = httpHeaders.getAll(headerName.getValue());
        return headerValueList != null && !headerValueList.isEmpty();
    }

    public static void removeAllHeaders(ObjectValue entityObj, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders != null) {
            httpHeaders.clear();
        }
    }

    public static void removeHeader(ObjectValue entityObj, BString headerName, Object position) {
        HttpHeaders httpHeaders = EntityHeaders.getHeadersBasedOnPosition(entityObj, position);
        if (httpHeaders != null) {
            httpHeaders.remove(headerName.getValue());
        }
    }

    public static void setHeader(ObjectValue entityObj, BString headerName, BString headerValue, Object position) {
        if (headerName == null || headerValue == null) {
            return;
        }
        try {
            EntityHeaders.getOrCreateHeadersBasedOnPosition(entityObj, position).set(headerName.getValue(), (Object)headerValue.getValue());
        }
        catch (IllegalArgumentException ex) {
            throw MimeUtil.createError("InvalidHeaderOperationError", ex.getMessage());
        }
    }

    private static HttpHeaders getHeadersBasedOnPosition(ObjectValue entityObj, Object position) {
        return position.equals(StringUtils.fromString((String)"leading")) ? (HttpHeaders)entityObj.getNativeData("entity_headers") : (HttpHeaders)entityObj.getNativeData("entity_trailer_headers");
    }

    private static HttpHeaders getOrCreateHeadersBasedOnPosition(ObjectValue entityObj, Object position) {
        return position.equals(StringUtils.fromString((String)"leading")) ? EntityHeaders.getHeaders(entityObj) : EntityHeaders.getTrailerHeaders(entityObj);
    }

    private static HttpHeaders getHeaders(ObjectValue entityObj) {
        DefaultHttpHeaders httpHeaders;
        if (entityObj.getNativeData("entity_headers") != null) {
            httpHeaders = (HttpHeaders)entityObj.getNativeData("entity_headers");
        } else {
            httpHeaders = new DefaultHttpHeaders();
            entityObj.addNativeData("entity_headers", (Object)httpHeaders);
        }
        return httpHeaders;
    }

    private static HttpHeaders getTrailerHeaders(ObjectValue entityObj) {
        HttpHeaders httpTrailerHeaders;
        if (entityObj.getNativeData("entity_trailer_headers") != null) {
            httpTrailerHeaders = (HttpHeaders)entityObj.getNativeData("entity_trailer_headers");
        } else {
            httpTrailerHeaders = new DefaultLastHttpContent().trailingHeaders();
            entityObj.addNativeData("entity_trailer_headers", (Object)httpTrailerHeaders);
        }
        return httpTrailerHeaders;
    }
}

