/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Locale;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.mime.nativeimpl.AbstractGetPayloadHandler;
import org.ballerinalang.mime.util.EntityBodyChannel;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.EntityWrapper;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeConstants;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.mime.util.MultipartDataSource;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.IOConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public class MimeEntityBody {
    private static final Logger log = LoggerFactory.getLogger(MimeEntityBody.class);

    public static Object getBodyParts(ObjectValue entityObj) {
        try {
            String baseType = HeaderUtil.getBaseType(entityObj);
            if (baseType != null && (baseType.toLowerCase(Locale.getDefault()).startsWith("multipart/") || baseType.toLowerCase(Locale.getDefault()).startsWith("message/"))) {
                Channel byteChannel;
                ArrayValue partsArray = EntityBodyHandler.getBodyPartArray(entityObj);
                if ((partsArray == null || partsArray.size() < 1) && (byteChannel = EntityBodyHandler.getByteChannel(entityObj)) != null) {
                    EntityBodyHandler.decodeEntityBody(entityObj, byteChannel);
                    partsArray = EntityBodyHandler.getBodyPartArray(entityObj);
                    entityObj.addNativeData("entity_byte_channel", null);
                }
                return partsArray;
            }
            return MimeUtil.createError("ParserError", "Entity body is not a type of composite media type. Received content-type : " + baseType);
        }
        catch (Throwable err) {
            return MimeUtil.createError("ParserError", "Error occurred while extracting body parts from entity: " + AbstractGetPayloadHandler.getErrorMsg(err));
        }
    }

    public static Object getBodyPartsAsChannel(ObjectValue entityObj) {
        try {
            String contentType = MimeUtil.getContentTypeWithParameters(entityObj);
            if (HeaderUtil.isMultipart(contentType)) {
                String boundaryValue = HeaderUtil.extractBoundaryParameter(contentType);
                String multipartDataBoundary = boundaryValue != null ? boundaryValue : MimeUtil.getNewMultipartDelimiter();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                MultipartDataSource multipartDataSource = new MultipartDataSource(entityObj, multipartDataBoundary);
                multipartDataSource.serialize(outputStream);
                EntityBodyChannel entityBodyChannel = new EntityBodyChannel(new ByteArrayInputStream(outputStream.toByteArray()));
                MimeUtil.closeOutputStream(outputStream);
                ObjectValue byteChannelObj = BallerinaValues.createObjectValue((BPackage)IOConstants.IO_PACKAGE_ID, (String)"ReadableByteChannel", (Object[])new Object[0]);
                byteChannelObj.addNativeData("byteChannel", (Object)new EntityWrapper(entityBodyChannel));
                return byteChannelObj;
            }
            return MimeUtil.createError("ParserError", "Entity doesn't contain body parts");
        }
        catch (Throwable err) {
            log.error("Error occurred while constructing a byte channel out of body parts", err);
            return MimeUtil.createError("ParserError", "Error occurred while constructing a byte channel out of body parts : " + AbstractGetPayloadHandler.getErrorMsg(err));
        }
    }

    public static Object getByteChannel(ObjectValue entityObj) {
        try {
            ObjectValue byteChannelObj = BallerinaValues.createObjectValue((BPackage)MimeConstants.PROTOCOL_IO_PKG_ID, (String)"ReadableByteChannel", (Object[])new Object[0]);
            MimeEntityBody.populateEntityWithByteChannel(entityObj);
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
            if (byteChannel != null) {
                byteChannelObj.addNativeData("byteChannel", (Object)byteChannel);
                return byteChannelObj;
            }
            if (EntityBodyHandler.getMessageDataSource(entityObj) != null) {
                return MimeUtil.createError("ParserError", "Byte channel is not available but payload can be obtain either as xml, json, string or byte[] type");
            }
            if (EntityBodyHandler.getBodyPartArray(entityObj) != null && EntityBodyHandler.getBodyPartArray(entityObj).size() != 0) {
                return MimeUtil.createError("ParserError", "Byte channel is not available since payload contains a set of body parts");
            }
            return MimeUtil.createError("ParserError", "Byte channel is not available as payload");
        }
        catch (Throwable err) {
            return MimeUtil.createError("ParserError", "Error occurred while constructing byte channel from entity body : " + AbstractGetPayloadHandler.getErrorMsg(err));
        }
    }

    private static void populateEntityWithByteChannel(ObjectValue entity) {
        HttpCarbonMessage httpCarbonMessage = (HttpCarbonMessage)entity.getNativeData("transport_message");
        if (httpCarbonMessage == null) {
            return;
        }
        HttpMessageDataStreamer httpMessageDataStreamer = new HttpMessageDataStreamer(httpCarbonMessage);
        long contentLength = MimeUtil.extractContentLength(httpCarbonMessage);
        if (contentLength > 0L) {
            entity.addNativeData("entity_byte_channel", (Object)new EntityWrapper(new EntityBodyChannel(httpMessageDataStreamer.getInputStream())));
        }
    }

    public static Object getMediaType(BString contentType) {
        try {
            ObjectValue mediaType = BallerinaValues.createObjectValue((BPackage)MimeConstants.PROTOCOL_MIME_PKG_ID, (String)"MediaType", (Object[])new Object[0]);
            return MimeUtil.parseMediaType(mediaType, contentType.getValue());
        }
        catch (Throwable err) {
            return MimeUtil.createError("InvalidContentTypeError", AbstractGetPayloadHandler.getErrorMsg(err));
        }
    }

    public static void setBodyParts(ObjectValue entityObj, ArrayValue bodyParts, BString contentType) {
        entityObj.addNativeData("body_parts", (Object)bodyParts);
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "multipart/form-data");
    }

    public static void setByteArray(ObjectValue entityObj, ArrayValue payload, BString contentType) {
        EntityBodyHandler.addMessageDataSource(entityObj, payload);
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "application/octet-stream");
    }

    public static void setByteChannel(ObjectValue entityObj, ObjectValue byteChannel, BString contentType) {
        entityObj.addNativeData("entity_byte_channel", byteChannel.getNativeData("byteChannel"));
        Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
        if (dataSource != null) {
            entityObj.addNativeData("message_datasource", null);
        }
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "application/octet-stream");
    }

    public static void setJson(ObjectValue entityObj, Object jsonContent, BString contentType) {
        EntityBodyHandler.addJsonMessageDataSource(entityObj, jsonContent);
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "application/json");
    }

    public static void setText(ObjectValue entityObj, BString textContent, BString contentType) {
        EntityBodyHandler.addMessageDataSource(entityObj, textContent.getValue());
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "text/plain");
    }

    public static void setXml(ObjectValue entityObj, XMLValue xmlContent, BString contentType) {
        EntityBodyHandler.addMessageDataSource(entityObj, xmlContent);
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "application/xml");
    }
}

