/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.mime.util.EntityBodyChannel;
import org.ballerinalang.mime.util.EntityWrapper;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeConstants;
import org.ballerinalang.mime.util.MimeEntityWrapper;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.mime.util.MultipartDecoder;
import org.ballerinalang.stdlib.io.channels.TempFileIOChannel;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.IOConstants;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.jvnet.mimepull.MIMEPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBodyHandler {
    private static final Logger log = LoggerFactory.getLogger(EntityBodyHandler.class);
    private static final BType MIME_ENTITY_TYPE = BallerinaValues.createObjectValue((BPackage)MimeConstants.PROTOCOL_MIME_PKG_ID, (String)"Entity", (Object[])new Object[0]).getType();
    private static final BArrayType mimeEntityArrayType = new BArrayType(MIME_ENTITY_TYPE);

    public static EntityWrapper getEntityWrapper(String textPayload) {
        return new EntityWrapper(new EntityBodyChannel(new ByteArrayInputStream(textPayload.getBytes(StandardCharsets.UTF_8))));
    }

    public static TempFileIOChannel getByteChannelForTempFile(String temporaryFilePath) {
        FileChannel fileChannel;
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        options.add(StandardOpenOption.READ);
        Path path = Paths.get(temporaryFilePath, new String[0]);
        try {
            fileChannel = (FileChannel)Files.newByteChannel(path, options, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw IOUtils.createError((IOConstants.ErrorCode)IOConstants.ErrorCode.GenericError, (String)"Error occurred while creating a file channel from a temporary file");
        }
        return new TempFileIOChannel(fileChannel, temporaryFilePath);
    }

    public static Object getMessageDataSource(ObjectValue entityObj) {
        return entityObj.getNativeData("message_datasource");
    }

    public static void addJsonMessageDataSource(ObjectValue entityObj, Object messageDataSource) {
        EntityBodyHandler.setParseJsonAndDataSource(entityObj, messageDataSource, true);
    }

    public static void addMessageDataSource(ObjectValue entityObj, Object messageDataSource) {
        EntityBodyHandler.setParseJsonAndDataSource(entityObj, messageDataSource, false);
    }

    private static void setParseJsonAndDataSource(ObjectValue entityObj, Object messageDataSource, boolean json) {
        entityObj.addNativeData("PARSE_AS_TEXT", (Object)json);
        entityObj.addNativeData("message_datasource", messageDataSource);
    }

    public static ArrayValue constructBlobDataSource(ObjectValue entityObj) throws IOException {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel == null) {
            return new ArrayValueImpl(new byte[0]);
        }
        try {
            ArrayValue arrayValue = EntityBodyHandler.constructBlobDataSource(byteChannel.getInputStream());
            return arrayValue;
        }
        finally {
            EntityBodyHandler.closeByteChannel(byteChannel);
        }
    }

    public static ArrayValue constructBlobDataSource(InputStream inputStream) {
        byte[] byteData;
        try {
            byteData = MimeUtil.getByteArray(inputStream);
        }
        catch (IOException ex) {
            throw BallerinaErrors.createError((String)("Error occurred while reading input stream :" + ex.getMessage()));
        }
        return new ArrayValueImpl(byteData);
    }

    public static Object constructJsonDataSource(ObjectValue entityObj) {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel == null) {
            return null;
        }
        try {
            Object object = EntityBodyHandler.constructJsonDataSource(entityObj, byteChannel.getInputStream());
            return object;
        }
        catch (IOException e) {
            throw BallerinaErrors.createError((String)e.getMessage());
        }
        finally {
            EntityBodyHandler.closeByteChannel(byteChannel);
        }
    }

    public static Object constructJsonDataSource(ObjectValue entity, InputStream inputStream) {
        String charsetValue;
        String contentTypeValue = HeaderUtil.getHeaderValue(entity, HttpHeaderNames.CONTENT_TYPE.toString());
        Object jsonData = MimeUtil.isNotNullAndEmpty(contentTypeValue) ? (MimeUtil.isNotNullAndEmpty(charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset")) ? JSONParser.parse((InputStream)inputStream, (String)charsetValue) : JSONParser.parse((InputStream)inputStream)) : JSONParser.parse((InputStream)inputStream);
        return jsonData;
    }

    public static XMLValue constructXmlDataSource(ObjectValue entityObj) {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel == null) {
            throw BallerinaErrors.createError((String)"Empty xml payload");
        }
        try {
            XMLValue xMLValue = EntityBodyHandler.constructXmlDataSource(entityObj, byteChannel.getInputStream());
            return xMLValue;
        }
        catch (IOException e) {
            throw BallerinaErrors.createError((String)e.getMessage());
        }
        finally {
            EntityBodyHandler.closeByteChannel(byteChannel);
        }
    }

    public static XMLValue constructXmlDataSource(ObjectValue entityObj, InputStream inputStream) {
        String charsetValue;
        String contentTypeValue = HeaderUtil.getHeaderValue(entityObj, HttpHeaderNames.CONTENT_TYPE.toString());
        XMLValue xmlContent = MimeUtil.isNotNullAndEmpty(contentTypeValue) ? (MimeUtil.isNotNullAndEmpty(charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset")) ? XMLFactory.parse((InputStream)inputStream, (String)charsetValue) : XMLFactory.parse((InputStream)inputStream)) : XMLFactory.parse((InputStream)inputStream);
        return xmlContent;
    }

    public static BString constructStringDataSource(ObjectValue entityObj) {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel == null) {
            throw BallerinaErrors.createError((String)"String payload is null");
        }
        try {
            BString bString = EntityBodyHandler.constructStringDataSource(entityObj, byteChannel.getInputStream());
            return bString;
        }
        catch (IOException e) {
            throw BallerinaErrors.createError((String)e.getMessage());
        }
        finally {
            EntityBodyHandler.closeByteChannel(byteChannel);
        }
    }

    public static BString constructStringDataSource(ObjectValue entity, InputStream inputStream) {
        String charsetValue;
        String contentTypeValue = HeaderUtil.getHeaderValue(entity, HttpHeaderNames.CONTENT_TYPE.toString());
        BString textContent = MimeUtil.isNotNullAndEmpty(contentTypeValue) ? (MimeUtil.isNotNullAndEmpty(charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset")) ? StringUtils.getStringFromInputStream((InputStream)inputStream, (String)charsetValue) : StringUtils.getStringFromInputStream((InputStream)inputStream)) : StringUtils.getStringFromInputStream((InputStream)inputStream);
        return textContent;
    }

    public static boolean checkEntityBodyAvailability(ObjectValue entityObj) {
        return entityObj.getNativeData("entity_byte_channel") != null || EntityBodyHandler.getMessageDataSource(entityObj) != null || entityObj.getNativeData("body_parts") != null;
    }

    public static boolean isStreamingRequired(ObjectValue entity) {
        return entity.getNativeData("entity_byte_channel") != null || entity.getNativeData("body_parts") != null;
    }

    static void setPartsToTopLevelEntity(ObjectValue entity, ArrayList<ObjectValue> bodyParts) {
        if (!bodyParts.isEmpty()) {
            BObjectType typeOfBodyPart = bodyParts.get(0).getType();
            Object[] result = bodyParts.toArray(new ObjectValue[bodyParts.size()]);
            ArrayValueImpl partsArray = new ArrayValueImpl(result, new BArrayType((BType)typeOfBodyPart));
            entity.addNativeData("body_parts", (Object)partsArray);
        }
    }

    public static void populateBodyContent(ObjectValue bodyPart, MIMEPart mimePart) {
        bodyPart.addNativeData("entity_byte_channel", (Object)new MimeEntityWrapper(new EntityBodyChannel(mimePart.readOnce()), mimePart));
    }

    public static void writeByteChannelToOutputStream(ObjectValue entityObj, OutputStream messageOutputStream) throws IOException {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel != null) {
            MimeUtil.writeInputToOutputStream(byteChannel.getInputStream(), messageOutputStream);
            byteChannel.close();
            entityObj.addNativeData("entity_byte_channel", null);
        }
    }

    public static void decodeEntityBody(ObjectValue entityObj, Channel byteChannel) throws IOException {
        String contentType = MimeUtil.getContentTypeWithParameters(entityObj);
        if (!MimeUtil.isNotNullAndEmpty(contentType) || !contentType.startsWith("multipart/")) {
            return;
        }
        try {
            MultipartDecoder.parseBody(entityObj, contentType, byteChannel.getInputStream());
        }
        catch (IOException e) {
            throw new IOException("Unable to get a byte channel input stream to decode entity body", e);
        }
    }

    public static ArrayValue getBodyPartArray(ObjectValue entityObj) {
        return entityObj.getNativeData("body_parts") != null ? (ArrayValue)entityObj.getNativeData("body_parts") : (ArrayValue)BValueCreator.createArrayValue((BArrayType)mimeEntityArrayType, (int)0);
    }

    public static Channel getByteChannel(ObjectValue entityObj) {
        return entityObj.getNativeData("entity_byte_channel") != null ? (Channel)entityObj.getNativeData("entity_byte_channel") : null;
    }

    private static void closeByteChannel(Channel byteChannel) {
        try {
            byteChannel.close();
        }
        catch (IOException e) {
            log.error("Error occurred while closing byte channel", (Throwable)e);
        }
    }
}

