/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeConstants;
import org.ballerinalang.mime.util.MimeUtil;
import org.jvnet.mimepull.MIMEConfig;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEPart;

public class MultipartDecoder {
    public static void parseBody(ObjectValue entity, String contentType, InputStream inputStream) {
        try {
            List<MIMEPart> mimeParts = MultipartDecoder.decodeBodyParts(contentType, inputStream);
            if (mimeParts != null && !mimeParts.isEmpty()) {
                MultipartDecoder.populateBallerinaParts(entity, mimeParts);
            }
        }
        catch (MimeTypeParseException e) {
            throw MimeUtil.createError("ParserError", "Error occurred while decoding body parts from inputstream " + e.getMessage());
        }
    }

    public static List<MIMEPart> decodeBodyParts(String contentType, InputStream inputStream) throws MimeTypeParseException {
        MimeType mimeType = new MimeType(contentType);
        MIMEMessage mimeMessage = new MIMEMessage(inputStream, mimeType.getParameter("boundary"), MultipartDecoder.getMimeConfig());
        return mimeMessage.getAttachments();
    }

    private static MIMEConfig getMimeConfig() {
        MIMEConfig mimeConfig = new MIMEConfig();
        mimeConfig.setMemoryThreshold(MultipartDecoder.getMemoryThreshold().longValue());
        return mimeConfig;
    }

    private static Long getMemoryThreshold() {
        Long freeMemorySize = Runtime.getRuntime().freeMemory();
        Double maxThreshold = (double)freeMemorySize.longValue() * 0.1;
        return maxThreshold.longValue();
    }

    private static void populateBallerinaParts(ObjectValue entity, List<MIMEPart> mimeParts) {
        ArrayList<ObjectValue> bodyParts = new ArrayList<ObjectValue>();
        for (MIMEPart mimePart : mimeParts) {
            ObjectValue partStruct = BallerinaValues.createObjectValue((BPackage)MimeConstants.PROTOCOL_MIME_PKG_ID, (String)"Entity", (Object[])new Object[0]);
            ObjectValue mediaType = BallerinaValues.createObjectValue((BPackage)MimeConstants.PROTOCOL_MIME_PKG_ID, (String)"MediaType", (Object[])new Object[0]);
            MultipartDecoder.populateBodyPart(mimePart, partStruct, mediaType);
            bodyParts.add(partStruct);
        }
        EntityBodyHandler.setPartsToTopLevelEntity(entity, bodyParts);
    }

    private static void populateBodyPart(MIMEPart mimePart, ObjectValue partStruct, ObjectValue mediaType) {
        partStruct.addNativeData("entity_headers", (Object)HeaderUtil.setBodyPartHeaders(mimePart.getAllHeaders(), (HttpHeaders)new DefaultHttpHeaders()));
        MultipartDecoder.populateContentLength(mimePart, partStruct);
        MultipartDecoder.populateContentId(mimePart, partStruct);
        MultipartDecoder.populateContentType(mimePart, partStruct, mediaType);
        List contentDispositionHeaders = mimePart.getHeader(HttpHeaderNames.CONTENT_DISPOSITION.toString());
        if (HeaderUtil.isHeaderExist(contentDispositionHeaders)) {
            ObjectValue contentDisposition = BallerinaValues.createObjectValue((BPackage)MimeConstants.PROTOCOL_MIME_PKG_ID, (String)"ContentDisposition", (Object[])new Object[0]);
            MultipartDecoder.populateContentDisposition(partStruct, contentDispositionHeaders, contentDisposition);
        }
        EntityBodyHandler.populateBodyContent(partStruct, mimePart);
    }

    private static void populateContentDisposition(ObjectValue partStruct, List<String> contentDispositionHeaders, ObjectValue contentDisposition) {
        MimeUtil.setContentDisposition(contentDisposition, partStruct, contentDispositionHeaders.get(0));
    }

    private static void populateContentType(MIMEPart mimePart, ObjectValue partStruct, ObjectValue mediaType) {
        MimeUtil.setContentType(mediaType, partStruct, mimePart.getContentType());
    }

    private static void populateContentId(MIMEPart mimePart, ObjectValue partStruct) {
        partStruct.set(MimeConstants.CONTENT_ID_FIELD, (Object)StringUtils.fromString((String)mimePart.getContentId()));
    }

    private static void populateContentLength(MIMEPart mimePart, ObjectValue partStruct) {
        List lengthHeaders = mimePart.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        if (HeaderUtil.isHeaderExist(lengthHeaders)) {
            MimeUtil.setContentLength(partStruct, Integer.parseInt((String)lengthHeaders.get(0)));
        } else {
            MimeUtil.setContentLength(partStruct, -1L);
        }
    }
}

