/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.runtime.nativeimpl;

import java.util.UUID;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ValueCreator;

public class GetInvocationContext {
    private static final String INVOCATION_CONTEXT_PROPERTY = "InvocationContext";
    private static final String STRUCT_TYPE_INVOCATION_CONTEXT = "InvocationContext";
    private static final String INVOCATION_ID_KEY = "id";
    private static final String INVOCATION_ATTRIBUTES = "attributes";
    private static final ValueCreator valueCreator = ValueCreator.getValueCreator((String)BLangConstants.BALLERINA_RUNTIME_PKG_ID.toString());

    public static MapValue<String, Object> getInvocationContext() {
        return GetInvocationContext.getInvocationContextRecord(Scheduler.getStrand());
    }

    private static MapValue<String, Object> getInvocationContextRecord(Strand strand) {
        MapValue<String, Object> invocationContext = (MapValue<String, Object>)strand.getProperty("InvocationContext");
        if (invocationContext == null) {
            invocationContext = GetInvocationContext.initInvocationContext();
            strand.setProperty("InvocationContext", invocationContext);
        }
        return invocationContext;
    }

    private static MapValue<String, Object> initInvocationContext() {
        MapValue invocationContextInfo = valueCreator.createRecordValue("InvocationContext");
        UUID invocationId = UUID.randomUUID();
        invocationContextInfo.put((Object)INVOCATION_ID_KEY, (Object)invocationId.toString());
        invocationContextInfo.put((Object)INVOCATION_ATTRIBUTES, (Object)new MapValueImpl());
        return invocationContextInfo;
    }
}

