/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.jvm.BLock;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;

public class BLockStore {
    private Map<String, BLock> globalLockMap = new ConcurrentHashMap<String, BLock>();

    public void addLockToMap(String lockName) {
        this.globalLockMap.put(lockName, new BLock());
    }

    public BLock getLockFromMap(String lockName) {
        return this.globalLockMap.computeIfAbsent(lockName, k -> new BLock());
    }

    public void panicIfInLock(String lockName, Strand strand) {
        BLock lock = this.getLockFromMap(lockName);
        if (lock.isLockFree()) {
            return;
        }
        if (lock.lockedBySameContext(strand)) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.ASYNC_CALL_INSIDE_LOCK);
        }
    }
}

