/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.util.LinkedList;
import java.util.Optional;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.StringValue;
import org.ballerinalang.jvm.values.api.BString;

public class BallerinaErrors {
    public static final String ERROR_MESSAGE_FIELD = "message";
    public static final String NULL_REF_EXCEPTION = "NullReferenceException";
    public static final String CALL_STACK_ELEMENT = "CallStackElement";
    public static final String ERROR_CAUSE_FIELD = "cause";
    public static final String ERROR_STACK_TRACE = "stackTrace";
    public static final String ERROR_PRINT_PREFIX = "error: ";
    public static final String GENERATE_PKG_INIT = "___init_";
    public static final String GENERATE_PKG_START = "___start_";
    public static final String GENERATE_PKG_STOP = "___stop_";
    public static final String GENERATE_OBJECT_CLASS_PREFIX = ".$value$";

    @Deprecated
    public static ErrorValue createError(String reason) {
        return new ErrorValue(reason, new MapValueImpl(BTypes.typeErrorDetail));
    }

    public static ErrorValue createError(BString reason) {
        return new ErrorValue((StringValue)reason, new MapValueImpl(BTypes.typeErrorDetail));
    }

    @Deprecated
    public static ErrorValue createError(String reason, String detail) {
        MapValueImpl<String, String> detailMap = new MapValueImpl<String, String>(BTypes.typeErrorDetail);
        if (detail != null) {
            detailMap.put(ERROR_MESSAGE_FIELD, detail);
        }
        return new ErrorValue(reason, detailMap);
    }

    public static ErrorValue createError(BString reason, String detail) {
        MapValueImpl<String, String> detailMap = new MapValueImpl<String, String>(BTypes.typeErrorDetail);
        if (detail != null) {
            detailMap.put(ERROR_MESSAGE_FIELD, detail);
        }
        return new ErrorValue((StringValue)reason, detailMap);
    }

    @Deprecated
    public static ErrorValue createError(BType type, String reason, String detail) {
        MapValueImpl<String, String> detailMap = new MapValueImpl<String, String>(BTypes.typeErrorDetail);
        if (detail != null) {
            detailMap.put(ERROR_MESSAGE_FIELD, detail);
        }
        return new ErrorValue(type, reason, detailMap);
    }

    public static ErrorValue createError(BType type, BString reason, String detail) {
        MapValueImpl<String, String> detailMap = new MapValueImpl<String, String>(BTypes.typeErrorDetail);
        if (detail != null) {
            detailMap.put(ERROR_MESSAGE_FIELD, detail);
        }
        return new ErrorValue(type, (StringValue)reason, detailMap);
    }

    @Deprecated
    public static ErrorValue createError(String reason, MapValue detailMap) {
        return new ErrorValue(reason, (Object)detailMap);
    }

    public static ErrorValue createError(BString reason, MapValue detailMap) {
        return new ErrorValue((StringValue)reason, (Object)detailMap);
    }

    public static ErrorValue createError(Throwable error) {
        if (error instanceof ErrorValue) {
            return (ErrorValue)error;
        }
        return BallerinaErrors.createError(error.getMessage());
    }

    public static ErrorValue trapError(Throwable throwable) {
        ErrorValue error = BallerinaErrors.createError(BallerinaErrorReasons.STACK_OVERFLOW_ERROR);
        error.setStackTrace(throwable.getStackTrace());
        return error;
    }

    public static ErrorValue createConversionError(Object inputValue, BType targetType) {
        return BallerinaErrors.createError(BallerinaErrorReasons.BALLERINA_PREFIXED_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_CONVERT_OPERATION, TypeChecker.getType(inputValue), targetType));
    }

    public static ErrorValue createTypeCastError(Object sourceVal, BType targetType) {
        throw BallerinaErrors.createError(BallerinaErrorReasons.TYPE_CAST_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.TYPE_CAST_ERROR, TypeChecker.getType(sourceVal), targetType));
    }

    public static ErrorValue createBToJTypeCastError(Object sourceVal, String targetType) {
        throw BallerinaErrors.createError(BallerinaErrorReasons.TYPE_CAST_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.J_TYPE_CAST_ERROR, TypeChecker.getType(sourceVal), targetType));
    }

    public static ErrorValue createNumericConversionError(Object inputValue, BType targetType) {
        throw BallerinaErrors.createError(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, TypeChecker.getType(inputValue), inputValue, targetType));
    }

    public static ErrorValue createNumericConversionError(Object inputValue, BType inputType, BType targetType) {
        throw BallerinaErrors.createError(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, inputType, inputValue, targetType));
    }

    static String getErrorMessageFromDetail(MapValueImpl<String, Object> detailMap) {
        return (String)detailMap.get(ERROR_MESSAGE_FIELD);
    }

    public static ErrorValue createCancelledFutureError() {
        return BallerinaErrors.createError(BallerinaErrorReasons.FUTURE_CANCELLED);
    }

    public static ErrorValue createNullReferenceError() {
        return BallerinaErrors.createError(NULL_REF_EXCEPTION);
    }

    public static ErrorValue createInteropError(Throwable e) {
        MapValueImpl<String, Object> detailMap = new MapValueImpl<String, Object>(BTypes.typeErrorDetail);
        if (e.getMessage() != null) {
            detailMap.put(ERROR_MESSAGE_FIELD, e.getMessage());
        }
        if (e.getCause() != null) {
            detailMap.put(ERROR_CAUSE_FIELD, BallerinaErrors.createError(e.getCause().getClass().getName(), e.getCause().getMessage()));
        }
        return BallerinaErrors.createError(e.getClass().getName(), detailMap);
    }

    public static Object handleResourceError(Object returnValue) {
        if (returnValue instanceof ErrorValue) {
            throw (ErrorValue)returnValue;
        }
        return returnValue;
    }

    public static ArrayValue generateCallStack() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        LinkedList<StackTraceElement> filteredStack = new LinkedList<StackTraceElement>();
        int index = 0;
        for (StackTraceElement stackFrame : stackTrace) {
            Optional<StackTraceElement> stackTraceElement;
            if (!(stackTraceElement = BallerinaErrors.filterStackTraceElement(stackFrame, index++)).isPresent()) continue;
            filteredStack.add(stackTraceElement.get());
        }
        BType recordType = BallerinaValues.createRecordValue(BLangConstants.BALLERINA_RUNTIME_PKG_ID, CALL_STACK_ELEMENT).getType();
        ArrayValueImpl callStack = new ArrayValueImpl(new BArrayType(recordType));
        for (int i = 0; i < filteredStack.size(); ++i) {
            callStack.add((long)i, BallerinaErrors.getStackFrame((StackTraceElement)filteredStack.get(i)));
        }
        return callStack;
    }

    public static Optional<StackTraceElement> filterStackTraceElement(StackTraceElement stackFrame, int currentIndex) {
        String fileName = stackFrame.getFileName();
        int lineNo = stackFrame.getLineNumber();
        if (lineNo < 0) {
            return Optional.empty();
        }
        String className = stackFrame.getClassName();
        String methodName = stackFrame.getMethodName();
        if (className.equals("___init")) {
            if (currentIndex == 0) {
                return Optional.empty();
            }
            switch (methodName) {
                case "___init_": {
                    methodName = "..<init>";
                    break;
                }
                case "___start_": {
                    methodName = ".<start>";
                    break;
                }
                case "___stop_": {
                    methodName = ".<stop>";
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(new StackTraceElement(BallerinaErrors.cleanupClassName(className), methodName, fileName, stackFrame.getLineNumber()));
        }
        if (fileName != null && !fileName.endsWith(".bal")) {
            return Optional.empty();
        }
        return Optional.of(new StackTraceElement(BallerinaErrors.cleanupClassName(className), methodName, fileName, stackFrame.getLineNumber()));
    }

    private static MapValue<String, Object> getStackFrame(StackTraceElement stackTraceElement) {
        Object[] values = new Object[]{stackTraceElement.getMethodName(), stackTraceElement.getClassName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()};
        return BallerinaValues.createRecord(BallerinaValues.createRecordValue(BLangConstants.BALLERINA_RUNTIME_PKG_ID, CALL_STACK_ELEMENT), values);
    }

    private static String cleanupClassName(String className) {
        return className.replace(GENERATE_OBJECT_CLASS_PREFIX, ".");
    }
}

