/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.values.XMLComment;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLPi;
import org.ballerinalang.jvm.values.XMLQName;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BMap;
import org.ballerinalang.jvm.values.api.BXML;

public class XMLTreeBuilder {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private XMLStreamReader xmlStreamReader;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Deque<XMLSequence> seqDeque = new ArrayDeque<XMLSequence>();
    private Deque<List<BXML>> siblingDeque = new ArrayDeque<List<BXML>>();

    public XMLTreeBuilder(String str) {
        this(new StringReader(str));
    }

    public XMLTreeBuilder(Reader stringReader) {
        ArrayList<BXML> siblings = new ArrayList<BXML>();
        this.siblingDeque.push(siblings);
        this.seqDeque.push(new XMLSequence(siblings));
        try {
            this.xmlStreamReader = xmlInputFactory.createXMLStreamReader(stringReader);
        }
        catch (XMLStreamException e) {
            this.handleXMLStreamException(e);
        }
    }

    private void handleXMLStreamException(Exception e) {
        String reason = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
        throw BallerinaErrors.createError(StringUtils.fromString(reason));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLValue parse() {
        try {
            block11: while (this.xmlStreamReader.hasNext()) {
                int next = this.xmlStreamReader.next();
                switch (next) {
                    case 1: {
                        this.readElement(this.xmlStreamReader);
                        continue block11;
                    }
                    case 2: {
                        this.endElement();
                        continue block11;
                    }
                    case 3: {
                        this.readPI(this.xmlStreamReader);
                        continue block11;
                    }
                    case 5: {
                        this.readComment(this.xmlStreamReader);
                        continue block11;
                    }
                    case 4: 
                    case 12: {
                        this.readText(this.xmlStreamReader);
                        continue block11;
                    }
                    case 8: {
                        return this.buildDocument();
                    }
                    case 11: {
                        this.handleDTD(this.xmlStreamReader);
                        continue block11;
                    }
                }
                assert (false);
            }
            return null;
        }
        catch (Exception e) {
            this.handleXMLStreamException(e);
        }
        return null;
    }

    private void handleDTD(XMLStreamReader xmlStreamReader) {
    }

    private void readPI(XMLStreamReader xmlStreamReader) {
        XMLPi xmlItem = (XMLPi)XMLFactory.createXMLProcessingInstruction(xmlStreamReader.getPITarget(), xmlStreamReader.getPIData());
        this.siblingDeque.peek().add(xmlItem);
    }

    private void readText(XMLStreamReader xmlStreamReader) {
        this.siblingDeque.peek().add(XMLFactory.createXMLText(xmlStreamReader.getText()));
    }

    private void readComment(XMLStreamReader xmlStreamReader) {
        XMLComment xmlComment = (XMLComment)XMLFactory.createXMLComment(xmlStreamReader.getText());
        this.siblingDeque.peek().add(xmlComment);
    }

    private XMLValue buildDocument() {
        this.siblingDeque.pop();
        return this.seqDeque.pop();
    }

    private void endElement() {
        this.siblingDeque.pop();
        this.seqDeque.pop();
    }

    private void readElement(XMLStreamReader xmlStreamReader) {
        QName elemName = xmlStreamReader.getName();
        XMLQName name = new XMLQName(elemName.getLocalPart(), elemName.getNamespaceURI(), elemName.getPrefix());
        XMLItem xmlItem = (XMLItem)XMLFactory.createXMLElement(name, name, null);
        this.seqDeque.push(xmlItem.getChildrenSeq());
        this.siblingDeque.peek().add(xmlItem);
        this.populateAttributeMap(xmlStreamReader, xmlItem, elemName);
        this.siblingDeque.push(xmlItem.getChildrenSeq().getChildrenList());
    }

    private void populateAttributeMap(XMLStreamReader xmlStreamReader, XMLItem xmlItem, QName elemName) {
        String xmlnsPrefix;
        BMap attributesMap = xmlItem.getAttributesMap();
        HashSet<QName> usedNS = new HashSet<QName>();
        int count = xmlStreamReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            QName attributeName = xmlStreamReader.getAttributeName(i);
            attributesMap.put(attributeName.toString(), xmlStreamReader.getAttributeValue(i));
            if (attributeName.getPrefix().isEmpty()) continue;
            usedNS.add(attributeName);
        }
        if (!elemName.getPrefix().isEmpty()) {
            usedNS.add(elemName);
        }
        for (QName qName : usedNS) {
            String prefix = qName.getPrefix();
            String namespaceURI = qName.getNamespaceURI();
            if (namespaceURI.isEmpty()) {
                namespaceURI = this.namespaces.getOrDefault(prefix, "");
            }
            xmlnsPrefix = "{http://www.w3.org/2000/xmlns/}" + prefix;
            attributesMap.put(xmlnsPrefix, namespaceURI);
        }
        int namespaceCount = xmlStreamReader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String uri = xmlStreamReader.getNamespaceURI(i);
            String prefix = xmlStreamReader.getNamespacePrefix(i);
            if (prefix == null || prefix.isEmpty()) {
                xmlnsPrefix = "{http://www.w3.org/2000/xmlns/}xmlns";
                attributesMap.put(xmlnsPrefix, uri);
                continue;
            }
            attributesMap.put("{http://www.w3.org/2000/xmlns/}" + prefix, uri);
        }
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }
}

