/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.observability.metrics;

import java.io.PrintStream;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.jvm.observability.BallerinaObserver;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.observability.metrics.DefaultMetricRegistry;
import org.ballerinalang.jvm.observability.metrics.Gauge;
import org.ballerinalang.jvm.observability.metrics.MetricId;
import org.ballerinalang.jvm.observability.metrics.MetricRegistry;
import org.ballerinalang.jvm.observability.metrics.StatisticConfig;
import org.ballerinalang.jvm.observability.metrics.Tag;
import org.ballerinalang.jvm.observability.metrics.Tags;

public class BallerinaMetricsObserver
implements BallerinaObserver {
    private static final String PROPERTY_START_TIME = "_observation_start_time_";
    private static final String TAG_KEY_SERVICE = "service";
    private static final String TAG_KEY_RESOURCE = "resource";
    private static final String TAG_KEY_ACTION = "action";
    private static final PrintStream consoleError = System.err;
    private static final MetricRegistry metricRegistry = DefaultMetricRegistry.getInstance();
    private static final StatisticConfig[] responseTimeStatisticConfigs = new StatisticConfig[]{StatisticConfig.builder().expiry(Duration.ofMinutes(1L)).percentiles(StatisticConfig.DEFAULT.getPercentiles()).build(), StatisticConfig.builder().expiry(Duration.ofMinutes(5L)).percentiles(StatisticConfig.DEFAULT.getPercentiles()).build(), StatisticConfig.builder().expiry(Duration.ofMinutes(15L)).percentiles(StatisticConfig.DEFAULT.getPercentiles()).build()};

    @Override
    public void startServerObservation(ObserverContext observerContext) {
        String[] mainTags = new String[]{TAG_KEY_SERVICE, observerContext.getServiceName(), TAG_KEY_RESOURCE, observerContext.getResourceName()};
        this.startObservation(observerContext, mainTags);
    }

    @Override
    public void startClientObservation(ObserverContext observerContext) {
        String[] mainTags = new String[]{TAG_KEY_ACTION, observerContext.getActionName()};
        this.startObservation(observerContext, mainTags);
    }

    @Override
    public void stopServerObservation(ObserverContext observerContext) {
        if (!observerContext.isStarted()) {
            return;
        }
        String[] mainTags = new String[]{TAG_KEY_SERVICE, observerContext.getServiceName(), TAG_KEY_RESOURCE, observerContext.getResourceName()};
        this.stopObservation(observerContext, mainTags);
    }

    @Override
    public void stopClientObservation(ObserverContext observerContext) {
        if (!observerContext.isStarted()) {
            return;
        }
        String[] mainTags = new String[]{TAG_KEY_ACTION, observerContext.getActionName()};
        this.stopObservation(observerContext, mainTags);
    }

    private void startObservation(ObserverContext observerContext, String[] mainTags) {
        observerContext.addProperty(PROPERTY_START_TIME, System.nanoTime());
        String connectorName = observerContext.getConnectorName();
        HashSet<Tag> mainTagSet = new HashSet<Tag>(mainTags.length);
        try {
            Tags.tags(mainTagSet, mainTags);
            this.getInprogressGauge(connectorName, mainTagSet).increment();
        }
        catch (RuntimeException e) {
            this.handleError(connectorName, mainTagSet, e);
        }
    }

    private void stopObservation(ObserverContext observerContext, String[] mainTags) {
        String connectorName = observerContext.getConnectorName();
        Map<String, String> tags = observerContext.getTags();
        HashSet<Tag> allTags = new HashSet<Tag>(tags.size() + mainTags.length);
        try {
            Boolean error;
            int httpStatusCode;
            Tags.tags(allTags, observerContext.getTags());
            Tags.tags(allTags, mainTags);
            HashSet<Tag> mainTagSet = new HashSet<Tag>(mainTags.length);
            Tags.tags(mainTagSet, mainTags);
            Long startTime = (Long)observerContext.getProperty(PROPERTY_START_TIME);
            long duration = System.nanoTime() - startTime;
            this.getInprogressGauge(connectorName, mainTagSet).decrement();
            metricRegistry.gauge(new MetricId(connectorName + "_response_time_seconds", "Response Time", allTags), responseTimeStatisticConfigs).setValue((double)duration / 1.0E9);
            metricRegistry.counter(new MetricId(connectorName + "_requests_total", "Total number of requests", allTags)).increment();
            String statusCode = tags.get("http.status_code");
            if (statusCode != null && (httpStatusCode = Integer.parseInt(statusCode)) > 0) {
                this.incrementHttpStatusCodeCounters(httpStatusCode, connectorName, mainTagSet);
            }
            if ((error = (Boolean)observerContext.getProperty("error")) != null && error.booleanValue()) {
                metricRegistry.counter(new MetricId(connectorName + "_failed_requests_total", "Total number of failed requests", allTags)).increment();
            }
        }
        catch (RuntimeException e) {
            this.handleError(connectorName, allTags, e);
        }
    }

    private Gauge getInprogressGauge(String connectorName, Set<Tag> tags) {
        return metricRegistry.gauge(new MetricId(connectorName + "_inprogress_requests", "Inprogress Requests", tags), new StatisticConfig[0]);
    }

    private void incrementHttpStatusCodeCounters(int statusCode, String connectorName, Set<Tag> tags) {
        metricRegistry.counter(new MetricId(connectorName + "_1XX_requests_total", "Total number of requests that resulted in HTTP 1xx informational responses", tags)).register();
        metricRegistry.counter(new MetricId(connectorName + "_2XX_requests_total", "Total number of requests that resulted in HTTP 2xx successful responses", tags)).register();
        metricRegistry.counter(new MetricId(connectorName + "_3XX_requests_total", "Total number of requests that resulted in HTTP 3xx redirections", tags)).register();
        metricRegistry.counter(new MetricId(connectorName + "_4XX_requests_total", "Total number of requests that resulted in HTTP 4xx client errors", tags)).register();
        metricRegistry.counter(new MetricId(connectorName + "_5XX_requests_total", "Total number of requests that resulted in HTTP 5xx server errors", tags)).register();
        if (statusCode >= 100 && statusCode < 200) {
            metricRegistry.counter(new MetricId(connectorName + "_1XX_requests_total", "Total number of requests that resulted in HTTP 1xx informational responses", tags)).increment();
        } else if (statusCode < 300) {
            metricRegistry.counter(new MetricId(connectorName + "_2XX_requests_total", "Total number of requests that resulted in HTTP 2xx successful responses", tags)).increment();
        } else if (statusCode < 400) {
            metricRegistry.counter(new MetricId(connectorName + "_3XX_requests_total", "Total number of requests that resulted in HTTP 3xx redirections", tags)).increment();
        } else if (statusCode < 500) {
            metricRegistry.counter(new MetricId(connectorName + "_4XX_requests_total", "Total number of requests that resulted in HTTP 4xx client errors", tags)).increment();
        } else if (statusCode < 600) {
            metricRegistry.counter(new MetricId(connectorName + "_5XX_requests_total", "Total number of requests that resulted in HTTP 5xx server errors", tags)).increment();
        }
    }

    private void handleError(String connectorName, Set<Tag> tags, RuntimeException e) {
        consoleError.println("error: error collecting metrics for " + connectorName + " with tags " + tags + ": " + e.getMessage());
    }
}

