/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.commons.ArrayState;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;

public class BArrayType
extends BType {
    private BType elementType;
    private int dimensions = 1;
    private int size = -1;
    private boolean hasFillerValue;
    private ArrayState state = ArrayState.UNSEALED;

    public BArrayType(BType elementType) {
        super(null, null, ArrayValue.class);
        this.elementType = elementType;
        if (elementType instanceof BArrayType) {
            this.dimensions = ((BArrayType)elementType).getDimensions() + 1;
        }
        this.hasFillerValue = TypeChecker.hasFillerValue(this.elementType);
    }

    public BArrayType(BType elemType, int size) {
        super(null, null, ArrayValue.class);
        this.elementType = elemType;
        if (this.elementType instanceof BArrayType) {
            this.dimensions = ((BArrayType)this.elementType).getDimensions() + 1;
        }
        if (size != -1) {
            this.state = ArrayState.CLOSED_SEALED;
            this.size = size;
        }
        this.hasFillerValue = TypeChecker.hasFillerValue(this.elementType);
    }

    public BType getElementType() {
        return this.elementType;
    }

    @Override
    public <V> V getZeroValue() {
        if (this.size == -1) {
            return this.getEmptyValue();
        }
        int tag = this.elementType.getTag();
        switch (tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return (V)new ArrayValueImpl(new BArrayType(this.elementType), this.size);
            }
        }
        return (V)new ArrayValueImpl(this);
    }

    @Override
    public <V> V getEmptyValue() {
        int tag = this.elementType.getTag();
        switch (tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return (V)new ArrayValueImpl(new BArrayType(this.elementType));
            }
        }
        return (V)new ArrayValueImpl(this);
    }

    @Override
    public int getTag() {
        return 20;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BArrayType) {
            BArrayType other = (BArrayType)obj;
            if (other.state == ArrayState.CLOSED_SEALED && this.size != other.size) {
                return false;
            }
            return this.elementType.equals(other.elementType);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.elementType.toString());
        return this.size != -1 ? sb.append("[").append(this.size).append("]").toString() : sb.append("[]").toString();
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int getSize() {
        return this.size;
    }

    public boolean hasFillerValue() {
        return this.hasFillerValue;
    }

    public ArrayState getState() {
        return this.state;
    }

    @Override
    public boolean isAnydata() {
        return this.elementType.isPureType();
    }
}

