/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.TypeFlags;
import org.ballerinalang.jvm.values.RefValue;

public class BFiniteType
extends BType {
    public Set<Object> valueSpace;
    private int typeFlags;

    public BFiniteType(String typeName) {
        super(typeName, null, RefValue.class);
        this.valueSpace = new LinkedHashSet<Object>();
    }

    public BFiniteType(String typeName, Set<Object> values, int typeFlags) {
        super(typeName, null, RefValue.class);
        this.valueSpace = values;
        this.typeFlags = typeFlags;
    }

    @Override
    public <V> V getZeroValue() {
        if (this.valueSpace.stream().anyMatch(val -> val == null || TypeChecker.getType(val).isNilable())) {
            return null;
        }
        Iterator<Object> valueIterator = this.valueSpace.iterator();
        Object firstVal = valueIterator.next();
        if (this.isSingletonType()) {
            return (V)firstVal;
        }
        Object implicitInitValOfType = TypeChecker.getType(firstVal).getZeroValue();
        if (implicitInitValOfType.equals(firstVal)) {
            return implicitInitValOfType;
        }
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            if (!implicitInitValOfType.equals(value)) continue;
            return implicitInitValOfType;
        }
        return null;
    }

    @Override
    public <V> V getEmptyValue() {
        if (this.valueSpace.stream().anyMatch(val -> val == null || TypeChecker.getType(val).isNilable())) {
            return null;
        }
        Iterator<Object> valueIterator = this.valueSpace.iterator();
        Object firstVal = valueIterator.next();
        if (this.isSingletonType()) {
            return (V)firstVal;
        }
        Object implicitInitValOfType = TypeChecker.getType(firstVal).getEmptyValue();
        if (implicitInitValOfType.equals(firstVal)) {
            return implicitInitValOfType;
        }
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            if (!implicitInitValOfType.equals(value)) continue;
            return implicitInitValOfType;
        }
        return null;
    }

    @Override
    public int getTag() {
        return 33;
    }

    private boolean isSingletonType() {
        return this.valueSpace.size() == 1;
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }
}

