/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.TypeFlags;
import org.ballerinalang.jvm.values.TupleValueImpl;

public class BTupleType
extends BType {
    private List<BType> tupleTypes;
    private BType restType;
    private int typeFlags;

    public BTupleType(List<BType> typeList) {
        super(null, null, Object.class);
        this.tupleTypes = typeList;
        this.restType = null;
        boolean isAllMembersPure = true;
        for (BType memberType : this.tupleTypes) {
            isAllMembersPure &= memberType.isPureType();
        }
        if (isAllMembersPure) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 2, 4);
        }
    }

    public BTupleType(List<BType> typeList, int typeFlags) {
        super(null, null, Object.class);
        this.tupleTypes = typeList;
        this.restType = null;
        this.typeFlags = typeFlags;
    }

    public BTupleType(List<BType> typeList, BType restType, int typeFlags) {
        super(null, null, Object.class);
        this.tupleTypes = typeList;
        this.restType = restType;
        this.typeFlags = typeFlags;
    }

    public List<BType> getTupleTypes() {
        return this.tupleTypes;
    }

    public BType getRestType() {
        return this.restType;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new TupleValueImpl(this);
    }

    @Override
    public <V> V getEmptyValue() {
        return this.getZeroValue();
    }

    @Override
    public int getTag() {
        return 31;
    }

    @Override
    public String toString() {
        List list = this.tupleTypes.stream().map(BType::toString).collect(Collectors.toList());
        return "[" + String.join((CharSequence)",", list) + "]";
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BTupleType)) {
            return false;
        }
        BTupleType that = (BTupleType)o;
        return Objects.equals(this.tupleTypes, that.tupleTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tupleTypes);
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }

    public int getTypeFlags() {
        return this.typeFlags;
    }
}

