/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ballerinalang.jvm.ColumnDefinition;
import org.ballerinalang.jvm.DataIterator;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.TableResourceManager;
import org.ballerinalang.jvm.TableUtils;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;

public class TableIterator
implements DataIterator {
    protected ResultSet rs;
    protected TableResourceManager resourceManager;
    protected BStructureType type;
    protected List<ColumnDefinition> columnDefs;

    public TableIterator(TableResourceManager rm, ResultSet rs, BStructureType type, List<ColumnDefinition> columnDefs) {
        this.resourceManager = rm;
        this.rs = rs;
        this.type = type;
        this.columnDefs = columnDefs;
    }

    public TableIterator(TableResourceManager rm, ResultSet rs, BStructureType type) {
        this.resourceManager = rm;
        this.rs = rs;
        this.type = type;
        this.generateColumnDefinitions();
    }

    @Override
    public boolean next() {
        if (this.rs == null) {
            return false;
        }
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.rs != null && !this.rs.isClosed()) {
                this.rs.close();
            }
            this.resourceManager.releaseResources();
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError(e);
        }
    }

    @Override
    public void reset() {
        this.close();
    }

    @Override
    public String getString(int columnIndex) {
        try {
            String val = this.rs.getString(columnIndex);
            return this.rs.wasNull() ? null : val;
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError(e);
        }
    }

    @Override
    public Long getInt(int columnIndex) {
        try {
            long val = this.rs.getLong(columnIndex);
            return this.rs.wasNull() ? null : Long.valueOf(val);
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError(e);
        }
    }

    @Override
    public Double getFloat(int columnIndex) {
        try {
            double val = this.rs.getDouble(columnIndex);
            return this.rs.wasNull() ? null : Double.valueOf(val);
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError(e);
        }
    }

    @Override
    public Boolean getBoolean(int columnIndex) {
        try {
            boolean val = this.rs.getBoolean(columnIndex);
            return this.rs.wasNull() ? null : Boolean.valueOf(val);
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError(e);
        }
    }

    @Override
    public String getBlob(int columnIndex) {
        try {
            Blob bValue = this.rs.getBlob(columnIndex);
            return this.rs.wasNull() ? null : new String(bValue.getBytes(1L, (int)bValue.length()));
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError(e);
        }
    }

    @Override
    public DecimalValue getDecimal(int columnIndex) {
        try {
            BigDecimal val = this.rs.getBigDecimal(columnIndex);
            return this.rs.wasNull() ? null : new DecimalValue(val);
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError(e);
        }
    }

    @Override
    public Object[] getStruct(int columnIndex) {
        Object[] objArray = null;
        try {
            Struct data = (Struct)this.rs.getObject(columnIndex);
            if (!this.rs.wasNull() && data != null) {
                objArray = data.getAttributes();
            }
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError(e);
        }
        return objArray;
    }

    @Override
    public Object[] getArray(int columnIndex) {
        try {
            return this.generateArrayDataResult(this.rs.getArray(columnIndex));
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError(e);
        }
    }

    private Object[] generateArrayDataResult(Array array) throws SQLException {
        Object[] objArray = null;
        if (!this.rs.wasNull()) {
            objArray = (Object[])array.getArray();
        }
        return objArray;
    }

    public MapValue<String, Object> generateNext() {
        MapValueImpl<String, Object> bStruct = new MapValueImpl<String, Object>(this.type);
        int index = 0;
        try {
            Collection<BField> structFields = this.type.getFields().values();
            for (BField sf : structFields) {
                BType type = sf.getFieldType();
                String fieldName = sf.getFieldName();
                Object value = null;
                ++index;
                switch (type.getTag()) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 20: {
                        value = this.fetchValue(index, type);
                        break;
                    }
                    case 21: {
                        List<BType> members = ((BUnionType)sf.getFieldType()).getMemberTypes();
                        if (members.size() != 2) {
                            throw TableUtils.createTableOperationError("corresponding Union type in the record is not an assignable nillable type");
                        }
                        if (members.get(0).getTag() == 10) {
                            value = this.fetchValue(index, members.get(1));
                            break;
                        }
                        if (members.get(1).getTag() == 10) {
                            value = this.fetchValue(index, members.get(0));
                            break;
                        }
                        throw TableUtils.createTableOperationError("corresponding Union type in the record is not an assignable nillable type");
                    }
                }
                bStruct.put(fieldName, value);
            }
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError("error in generating next row of data :" + e.getMessage());
        }
        return bStruct;
    }

    private Object fetchValue(int index, BType type) throws SQLException {
        Object value = null;
        switch (type.getTag()) {
            case 1: {
                value = this.rs.getLong(index);
                break;
            }
            case 5: {
                value = this.rs.getString(index);
                break;
            }
            case 3: {
                value = this.rs.getDouble(index);
                break;
            }
            case 4: {
                value = new DecimalValue(this.rs.getBigDecimal(index));
                break;
            }
            case 6: {
                value = this.rs.getBoolean(index);
                break;
            }
            case 7: {
                String jsonValue = this.rs.getString(index);
                value = JSONParser.parse(jsonValue);
                break;
            }
            case 8: {
                String xmlValue = this.rs.getString(index);
                value = XMLFactory.parse(xmlValue);
                break;
            }
            case 20: {
                BType arrayElementType = ((BArrayType)type).getElementType();
                if (arrayElementType.getTag() == 2) {
                    Blob blobValue = this.rs.getBlob(index);
                    if (blobValue == null) break;
                    value = new ArrayValueImpl(blobValue.getBytes(1L, (int)blobValue.length()));
                    break;
                }
                Array arrayValue = this.rs.getArray(index);
                value = this.getDataArray(arrayValue);
            }
        }
        if (this.rs.wasNull()) {
            value = null;
        }
        return value;
    }

    @Override
    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefs;
    }

    @Override
    public BStructureType getStructType() {
        return this.type;
    }

    protected ArrayValue getDataArray(Array array) throws SQLException {
        Object[] dataArray = this.generateArrayDataResult(array);
        if (dataArray == null || dataArray.length == 0) {
            return null;
        }
        ArrayElementAttributes nullabilityAttributes = this.getArrayElementNullabilityInfo(dataArray);
        Object firstNonNullElement = nullabilityAttributes.getFirstNonNullElement();
        boolean containsNull = nullabilityAttributes.containsNull();
        if (firstNonNullElement == null) {
            return new ArrayValueImpl(new BArrayType(BTypes.typeNull));
        }
        if (containsNull) {
            return this.createAndPopulateRefValueArray(firstNonNullElement, dataArray);
        }
        return this.createAndPopulatePrimitiveValueArray(firstNonNullElement, dataArray);
    }

    private ArrayValue createAndPopulatePrimitiveValueArray(Object firstNonNullElement, Object[] dataArray) {
        int length = dataArray.length;
        if (firstNonNullElement instanceof String) {
            ArrayValueImpl stringDataArray = new ArrayValueImpl(new BArrayType(BTypes.typeString));
            for (int i = 0; i < length; ++i) {
                stringDataArray.add((long)i, (String)dataArray[i]);
            }
            return stringDataArray;
        }
        if (firstNonNullElement instanceof Boolean) {
            ArrayValueImpl boolDataArray = new ArrayValueImpl(new BArrayType(BTypes.typeBoolean));
            for (int i = 0; i < length; ++i) {
                boolDataArray.add((long)i, (Boolean)dataArray[i]);
            }
            return boolDataArray;
        }
        if (firstNonNullElement instanceof Integer) {
            ArrayValueImpl intDataArray = new ArrayValueImpl(new BArrayType(BTypes.typeInt));
            for (int i = 0; i < length; ++i) {
                intDataArray.add((long)i, ((Integer)dataArray[i]).intValue());
            }
            return intDataArray;
        }
        if (firstNonNullElement instanceof Long) {
            ArrayValueImpl longDataArray = new ArrayValueImpl(new BArrayType(BTypes.typeInt));
            for (int i = 0; i < length; ++i) {
                longDataArray.add((long)i, (Long)dataArray[i]);
            }
            return longDataArray;
        }
        if (firstNonNullElement instanceof Float) {
            ArrayValueImpl floatDataArray = new ArrayValueImpl(new BArrayType(BTypes.typeFloat));
            for (int i = 0; i < length; ++i) {
                floatDataArray.add((long)i, ((Float)dataArray[i]).floatValue());
            }
            return floatDataArray;
        }
        if (firstNonNullElement instanceof Double) {
            ArrayValueImpl doubleDataArray = new ArrayValueImpl(new BArrayType(BTypes.typeFloat));
            for (int i = 0; i < dataArray.length; ++i) {
                doubleDataArray.add((long)i, (Double)dataArray[i]);
            }
            return doubleDataArray;
        }
        if (firstNonNullElement instanceof BigDecimal) {
            ArrayValueImpl decimalDataArray = new ArrayValueImpl(new BArrayType(BTypes.typeDecimal));
            for (int i = 0; i < dataArray.length; ++i) {
                decimalDataArray.add((long)i, new DecimalValue((BigDecimal)dataArray[i]));
            }
            return decimalDataArray;
        }
        return null;
    }

    private ArrayValue createAndPopulateRefValueArray(Object firstNonNullElement, Object[] dataArray) {
        ArrayValue refValueArray;
        block8: {
            int length;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    refValueArray = null;
                                    length = dataArray.length;
                                    if (!(firstNonNullElement instanceof String)) break block7;
                                    refValueArray = this.createEmptyRefValueArray(BTypes.typeString, length);
                                    for (int i = 0; i < length; ++i) {
                                        refValueArray.add((long)i, dataArray[i]);
                                    }
                                    break block8;
                                }
                                if (!(firstNonNullElement instanceof Boolean)) break block9;
                                refValueArray = this.createEmptyRefValueArray(BTypes.typeBoolean, length);
                                for (int i = 0; i < length; ++i) {
                                    refValueArray.add((long)i, dataArray[i]);
                                }
                                break block8;
                            }
                            if (!(firstNonNullElement instanceof Integer)) break block10;
                            refValueArray = this.createEmptyRefValueArray(BTypes.typeInt, length);
                            for (int i = 0; i < length; ++i) {
                                refValueArray.add((long)i, dataArray[i]);
                            }
                            break block8;
                        }
                        if (!(firstNonNullElement instanceof Long)) break block11;
                        refValueArray = this.createEmptyRefValueArray(BTypes.typeInt, length);
                        for (int i = 0; i < length; ++i) {
                            refValueArray.add((long)i, dataArray[i]);
                        }
                        break block8;
                    }
                    if (!(firstNonNullElement instanceof Float)) break block12;
                    refValueArray = this.createEmptyRefValueArray(BTypes.typeFloat, length);
                    for (int i = 0; i < length; ++i) {
                        refValueArray.add((long)i, dataArray[i]);
                    }
                    break block8;
                }
                if (!(firstNonNullElement instanceof Double)) break block13;
                refValueArray = this.createEmptyRefValueArray(BTypes.typeFloat, length);
                for (int i = 0; i < length; ++i) {
                    refValueArray.add((long)i, dataArray[i]);
                }
                break block8;
            }
            if (!(firstNonNullElement instanceof BigDecimal)) break block8;
            refValueArray = this.createEmptyRefValueArray(BTypes.typeDecimal, length);
            for (int i = 0; i < length; ++i) {
                refValueArray.add((long)i, dataArray[i] != null ? new DecimalValue((BigDecimal)dataArray[i]) : null);
            }
        }
        return refValueArray;
    }

    private ArrayValue createEmptyRefValueArray(BType type, int length) {
        ArrayList<BType> memberTypes = new ArrayList<BType>(2);
        memberTypes.add(type);
        memberTypes.add(BTypes.typeNull);
        BUnionType unionType = new BUnionType(memberTypes);
        return new ArrayValueImpl(new BArrayType(unionType));
    }

    private ArrayElementAttributes getArrayElementNullabilityInfo(Object[] objects) {
        int i;
        ArrayElementAttributes arrayElementAttributes = new ArrayElementAttributes();
        for (i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            arrayElementAttributes.setFirstNonNullElement(objects[i]);
            if (i > 0) {
                arrayElementAttributes.setContainsNull(true);
            }
            ++i;
            break;
        }
        if (!arrayElementAttributes.containsNull()) {
            while (i < objects.length) {
                if (objects[i] == null) {
                    arrayElementAttributes.setContainsNull(true);
                    break;
                }
                ++i;
            }
        }
        return arrayElementAttributes;
    }

    private void generateColumnDefinitions() {
        Collection<BField> structFields = this.type.getFields().values();
        this.columnDefs = new ArrayList<ColumnDefinition>(structFields.size());
        for (BField sf : structFields) {
            BType type = sf.getFieldType();
            int typeTag = 17;
            switch (type.getTag()) {
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    typeTag = type.getTag();
                    break;
                }
                case 20: {
                    BType elementType = ((BArrayType)type).getElementType();
                    typeTag = elementType.getTag() == 2 ? 2 : 20;
                }
            }
            ColumnDefinition def = new ColumnDefinition(sf.getFieldName(), typeTag);
            this.columnDefs.add(def);
        }
    }

    private static class ArrayElementAttributes {
        private Object firstNonNullElement;
        private boolean containsNull;

        private ArrayElementAttributes() {
        }

        private void setFirstNonNullElement(Object firstNonNullElement) {
            this.firstNonNullElement = firstNonNullElement;
        }

        private void setContainsNull(boolean containsNull) {
            this.containsNull = containsNull;
        }

        private Object getFirstNonNullElement() {
            return this.firstNonNullElement;
        }

        private boolean containsNull() {
            return this.containsNull;
        }
    }
}

