/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.Map;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMCommentImpl;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.XMLNonElementItem;
import org.ballerinalang.jvm.values.api.BString;

public class XMLComment
extends XMLNonElementItem {
    private String data;

    public XMLComment(String data) {
        this.data = data;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getTextValue() {
        return this.data;
    }

    @Override
    public XMLNodeType getNodeType() {
        return XMLNodeType.COMMENT;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        return new XMLComment(this.data);
    }

    @Override
    public OMNode value() {
        OMCommentImpl omComment = new OMCommentImpl();
        omComment.setValue(this.data);
        return omComment;
    }

    @Override
    public String stringValue() {
        return "<!--" + this.data + "-->";
    }

    @Override
    public BString bStringValue() {
        return StringUtils.fromString(this.stringValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XMLComment) {
            XMLComment that = (XMLComment)obj;
            return this.data.equals(that.data);
        }
        return false;
    }

    @Override
    public BType getType() {
        return BTypes.typeComment;
    }
}

