/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.axiom.om.OMNode;
import org.ballerinalang.jvm.BallerinaXMLSerializer;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLText;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BMap;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BXML;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.Status;

public abstract class XMLNonElementItem
extends XMLValue {
    @Override
    public abstract boolean isEmpty();

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public String getItemType() {
        return this.getNodeType().value();
    }

    @Override
    public String getElementName() {
        return null;
    }

    @Override
    public abstract String getTextValue();

    @Override
    public String getAttribute(String localName, String namespace) {
        return null;
    }

    @Override
    public String getAttribute(String localName, String namespace, String prefix) {
        return null;
    }

    @Override
    public void setAttribute(String localName, String namespace, String prefix, String value) {
    }

    @Override
    public MapValue<String, String> getAttributesMap() {
        return null;
    }

    @Override
    public void setAttributes(BMap<String, ?> attributes) {
    }

    @Override
    public BXML elements() {
        return new XMLSequence();
    }

    @Override
    public BXML elements(String qname) {
        return null;
    }

    @Override
    public XMLValue children() {
        return new XMLSequence();
    }

    @Override
    public XMLValue children(String qname) {
        return new XMLSequence();
    }

    @Override
    public void setChildren(BXML seq) {
    }

    @Override
    @Deprecated
    public void addChildren(BXML seq) {
    }

    @Override
    public BXML strip() {
        return new XMLText("");
    }

    @Override
    public abstract XMLNodeType getNodeType();

    @Override
    public BXML slice(long startIndex, long endIndex) {
        return null;
    }

    @Override
    public BXML descendants(List<String> qnames) {
        return new XMLSequence();
    }

    @Override
    public XMLValue getItem(int index) {
        if (index == 0) {
            return this;
        }
        return new XMLSequence();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void build() {
    }

    @Override
    public void removeAttribute(String qname) {
    }

    @Override
    @Deprecated
    public void removeChildren(String qname) {
    }

    public abstract OMNode value();

    @Override
    public IteratorValue getIterator() {
        return new IteratorValue(){

            @Override
            public BString bStringValue() {
                return null;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public String stringValue() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BallerinaXMLSerializer ballerinaXMLSerializer = new BallerinaXMLSerializer(outputStream);
            ballerinaXMLSerializer.write(this);
            ballerinaXMLSerializer.flush();
            String str = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            ballerinaXMLSerializer.close();
            return str;
        }
        catch (Throwable t) {
            XMLNonElementItem.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public void attemptFreeze(Status freezeStatus) {
        if (FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            this.freezeStatus = freezeStatus;
        }
    }

    @Override
    public void freezeDirect() {
        this.freezeStatus.setFrozen();
    }

    @Override
    public Object freeze() {
        this.freezeDirect();
        return this;
    }

    public abstract boolean equals(Object var1);
}

