/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.CharacterDataImpl;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.XMLNonElementItem;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BXML;

public class XMLText
extends XMLNonElementItem {
    private String data;

    public XMLText(String data) {
        this.data = data;
    }

    @Override
    public boolean isEmpty() {
        if (this.getNodeType() == XMLNodeType.TEXT) {
            return this.data.isEmpty();
        }
        return false;
    }

    @Override
    public String getItemType() {
        return this.getNodeType().value();
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public synchronized boolean isFrozen() {
        return true;
    }

    @Override
    public String getTextValue() {
        return this.data;
    }

    @Override
    public BXML strip() {
        if (!this.data.trim().isEmpty()) {
            return this;
        }
        return new XMLText("");
    }

    @Override
    public XMLNodeType getNodeType() {
        return XMLNodeType.TEXT;
    }

    @Override
    public OMNode value() {
        CharacterDataImpl characterData = new CharacterDataImpl();
        characterData.data = this.data;
        return characterData;
    }

    @Override
    public String stringValue() {
        try {
            return this.data;
        }
        catch (Throwable t) {
            XMLText.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public BString bStringValue() {
        return StringUtils.fromString(this.stringValue());
    }

    @Override
    public IteratorValue getIterator() {
        return new IteratorValue(){
            boolean read = false;

            @Override
            public boolean hasNext() {
                return !this.read;
            }

            @Override
            public BString bStringValue() {
                return null;
            }

            public Object next() {
                if (!this.read) {
                    this.read = true;
                    return XMLText.this.data;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XMLText) {
            XMLText that = (XMLText)obj;
            return this.data.equals(that.data);
        }
        return false;
    }

    @Override
    public BType getType() {
        return BTypes.typeText;
    }
}

