/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.config.cipher.AESCipherTool;
import org.ballerinalang.config.cipher.AESCipherToolException;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.BLauncherException;
import org.ballerinalang.tool.LauncherUtils;
import org.ballerinalang.tool.util.BCompileUtil;
import org.ballerinalang.tool.util.ToolUtil;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class Main {
    private static final String UNMATCHED_ARGUMENT_PREFIX = "Unmatched argument";
    private static final String MISSING_REQUIRED_PARAMETER_PREFIX = "Missing required parameter";
    private static final String COMPILATION_ERROR_MESSAGE = "compilation contains errors";
    private static PrintStream errStream = System.err;
    private static PrintStream outStream = System.out;
    private static final Logger breLog = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) {
        try {
            Optional<BLauncherCmd> optionalInvokedCmd = Main.getInvokedCmd(args);
            optionalInvokedCmd.ifPresent(BLauncherCmd::execute);
        }
        catch (BLangRuntimeException e) {
            errStream.println(e.getMessage());
            Runtime.getRuntime().exit(1);
        }
        catch (BLangCompilerException e) {
            if (!e.getMessage().contains(COMPILATION_ERROR_MESSAGE)) {
                errStream.println(Main.prepareCompilerErrorMessage(e.getMessage()));
            }
            Runtime.getRuntime().exit(1);
        }
        catch (BLauncherException e) {
            LauncherUtils.printLauncherException(e, errStream);
            Runtime.getRuntime().exit(1);
        }
        catch (Throwable e) {
            errStream.println(Main.getMessageForInternalErrors());
            breLog.error(e.getMessage(), e);
            Runtime.getRuntime().exit(1);
        }
    }

    private static Optional<BLauncherCmd> getInvokedCmd(String ... args) {
        try {
            DefaultCmd defaultCmd = new DefaultCmd();
            CommandLine cmdParser = new CommandLine((Object)defaultCmd);
            defaultCmd.setParentCmdParser(cmdParser);
            cmdParser.setStopAtPositional(true);
            HelpCmd helpCmd = new HelpCmd();
            cmdParser.addSubcommand("help", (Object)helpCmd);
            helpCmd.setParentCmdParser(cmdParser);
            ServiceLoader<BLauncherCmd> bCmds = ServiceLoader.load(BLauncherCmd.class);
            for (BLauncherCmd bCmd : bCmds) {
                cmdParser.addSubcommand(bCmd.getName(), (Object)bCmd);
                bCmd.setParentCmdParser(cmdParser);
            }
            VersionCmd versionCmd = new VersionCmd();
            cmdParser.addSubcommand("version", (Object)versionCmd);
            versionCmd.setParentCmdParser(cmdParser);
            EncryptCmd encryptCmd = new EncryptCmd();
            cmdParser.addSubcommand("encrypt", (Object)encryptCmd);
            encryptCmd.setParentCmdParser(cmdParser);
            SDKCmd sdkCmd = new SDKCmd();
            cmdParser.addSubcommand("sdks", (Object)sdkCmd);
            sdkCmd.setParentCmdParser(cmdParser);
            InstallCmd installCmd = new InstallCmd();
            cmdParser.addSubcommand("install", (Object)installCmd);
            installCmd.setParentCmdParser(cmdParser);
            UpdateCmd updateCmd = new UpdateCmd();
            cmdParser.addSubcommand("update", (Object)updateCmd);
            updateCmd.setParentCmdParser(cmdParser);
            RemoveCmd removeCmd = new RemoveCmd();
            cmdParser.addSubcommand("remove", (Object)removeCmd);
            removeCmd.setParentCmdParser(cmdParser);
            cmdParser.setCommandName("ballerina");
            cmdParser.setPosixClusteredShortOptionsAllowed(false);
            List parsedCommands = cmdParser.parse(args);
            if (parsedCommands.size() < 1) {
                return Optional.of(defaultCmd);
            }
            return Optional.of(((CommandLine)parsedCommands.get(parsedCommands.size() - 1)).getCommand());
        }
        catch (CommandLine.UnmatchedArgumentException e) {
            String errorMessage = e.getMessage();
            if (errorMessage == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("internal error occurred");
            }
            if (errorMessage.contains(UNMATCHED_ARGUMENT_PREFIX)) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command '" + Main.getFirstUnknownArg(errorMessage) + "'");
            }
            throw LauncherUtils.createUsageExceptionWithHelp(LauncherUtils.makeFirstLetterLowerCase(errorMessage));
        }
        catch (CommandLine.ParameterException e) {
            String msg = e.getMessage();
            if (msg == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("internal error occurred");
            }
            if (msg.startsWith(MISSING_REQUIRED_PARAMETER_PREFIX)) {
                throw LauncherUtils.createUsageExceptionWithHelp("flag " + msg.substring(msg.indexOf("'")) + " needs an argument");
            }
            throw LauncherUtils.createUsageExceptionWithHelp(LauncherUtils.makeFirstLetterLowerCase(msg));
        }
    }

    private static void printUsageInfo(String commandName) {
        String usageInfo = BLauncherCmd.getCommandUsageInfo(commandName);
        errStream.println(usageInfo);
    }

    private static void printVersionInfo() {
        try (InputStream inputStream = Main.class.getResourceAsStream("/META-INF/tool.properties");){
            Properties properties = new Properties();
            properties.load(inputStream);
            String output = "Ballerina " + properties.getProperty("ballerina.version") + "\n";
            output = output + "Language specification " + properties.getProperty("spec.version") + "\n";
            output = output + "Ballerina tool " + properties.getProperty("tool.version") + "\n";
            outStream.print(output);
        }
        catch (Throwable ignore) {
            throw LauncherUtils.createUsageExceptionWithHelp("version info not available");
        }
    }

    private static String getMessageForInternalErrors() {
        String errorMsg;
        try {
            errorMsg = BCompileUtil.readFileAsString("cli-help/internal-error-message.txt");
        }
        catch (IOException e) {
            errorMsg = "ballerina: internal error occurred";
        }
        return errorMsg;
    }

    private static String prepareCompilerErrorMessage(String message) {
        return "error: " + LauncherUtils.makeFirstLetterLowerCase(message);
    }

    private static String getFirstUnknownArg(String errorMessage) {
        String optionsString = errorMessage.split(":")[1];
        return optionsString.split(",")[0].trim();
    }

    @CommandLine.Command(description={"Default Command."}, name="default")
    private static class DefaultCmd
    implements BLauncherCmd {
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true, description={"for more information"})
        private boolean helpFlag;
        @CommandLine.Option(names={"--debug"}, description={"start Ballerina in remote debugging mode"})
        private String debugPort;
        @CommandLine.Option(names={"--version", "-v"}, hidden=true)
        private boolean versionFlag;

        private DefaultCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("help");
                return;
            }
            if (this.versionFlag) {
                Main.printVersionInfo();
                return;
            }
            Main.printUsageInfo("default");
        }

        @Override
        public String getName() {
            return "default";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
        }
    }

    @CommandLine.Command(name="remove", description={"Remove Ballerina SDK"})
    private static class RemoveCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> removeCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private RemoveCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("remove");
                return;
            }
            if (this.removeCommands == null) {
                ToolUtil.remove(outStream, "0.991.0");
                return;
            }
            if (this.removeCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.removeCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina remove\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="update", description={"Update Ballerina current SDK"})
    private static class UpdateCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> updateCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private UpdateCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("update");
                return;
            }
            if (this.updateCommands == null) {
                ToolUtil.update(outStream, "version");
                return;
            }
            if (this.updateCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.updateCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina update\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="install", description={"Install Ballerina SDK"})
    private static class InstallCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> installCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private InstallCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("install");
                return;
            }
            if (this.installCommands == null) {
                ToolUtil.install(outStream, "0.991.0");
                return;
            }
            if (this.installCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.installCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  install update\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="sdks", description={"List Ballerina SDKs"})
    private static class SDKCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> sdksCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private SDKCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("sdks");
                return;
            }
            if (this.sdksCommands == null) {
                ToolUtil.listSDKs(outStream);
                return;
            }
            if (this.sdksCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.sdksCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina sdks\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="encrypt", description={"encrypt sensitive data"})
    public static class EncryptCmd
    implements BLauncherCmd {
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("encrypt");
                return;
            }
            String value = this.promptForInput("Enter value: ");
            if (value.trim().isEmpty() && value.trim().isEmpty() && (value = this.promptForInput("Value cannot be empty; enter value: ")).trim().isEmpty()) {
                throw LauncherUtils.createLauncherException("encryption failed: empty value.");
            }
            String secret = this.promptForInput("Enter secret: ");
            if (secret.trim().isEmpty() && secret.trim().isEmpty() && (secret = this.promptForInput("Secret cannot be empty; enter secret: ")).trim().isEmpty()) {
                throw LauncherUtils.createLauncherException("encryption failed: empty secret.");
            }
            String secretVerifyVal = this.promptForInput("Re-enter secret to verify: ");
            if (!secret.equals(secretVerifyVal)) {
                throw LauncherUtils.createLauncherException("secrets did not match.");
            }
            try {
                AESCipherTool cipherTool = new AESCipherTool(secret);
                String encryptedValue = cipherTool.encrypt(value);
                errStream.println("Add the following to the runtime config:");
                errStream.println("@encrypted:{" + encryptedValue + "}\n");
                errStream.println("Or add to the runtime command line:");
                errStream.println("-e<param>=@encrypted:{" + encryptedValue + "}");
            }
            catch (AESCipherToolException e) {
                throw LauncherUtils.createLauncherException("failed to encrypt value: " + e.getMessage());
            }
        }

        @Override
        public String getName() {
            return "encrypt";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
            out.append("The encrypt command can be used to encrypt sensitive data.\n\n");
            out.append("When the command is executed, the user will be prompted to\n");
            out.append("enter the value to be encrypted and a secret. The secret will be used in \n");
            out.append("encrypting the value.\n\n");
            out.append("Once encrypted, the user can place the encrypted value in the config files,\n");
            out.append("similar to the following example:\n");
            out.append("\tuser.password=\"@encrypted:{UtD9d+o6eHpqFnBxtvhb+RWXey7qm7xLMt6+6mrt9w0=}\"\n\n");
            out.append("The Ballerina Config API will automatically decrypt the values on-demand.\n");
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina encrypt\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
        }

        private String promptForInput(String msg) {
            errStream.println(msg);
            return new String(System.console().readPassword());
        }
    }

    @CommandLine.Command(name="version", description={"Prints Ballerina version"})
    private static class VersionCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> versionCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private VersionCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("version");
                return;
            }
            if (this.versionCommands == null) {
                Main.printVersionInfo();
                return;
            }
            if (this.versionCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.versionCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina version\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="help", description={"print usage information"})
    private static class HelpCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> helpCommands;
        private CommandLine parentCmdParser;

        private HelpCmd() {
        }

        @Override
        public void execute() {
            if (this.helpCommands == null) {
                Main.printUsageInfo("help");
                return;
            }
            if (this.helpCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.helpCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown help topic `" + userCommand + "`");
            }
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo(userCommand);
            errStream.println(commandUsageInfo);
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }
}

