/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.BLangProgramRunner;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.tool.LauncherUtils;
import org.ballerinalang.tool.util.CompileResult;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.FileSystemProjectDirectory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;

public class BCompileUtil {
    private static Path resourceDir = Paths.get("src/test/resources", new String[0]).toAbsolutePath();

    public static CompileResult compileAndSetup(String sourceFilePath) {
        CompileResult compileResult = BCompileUtil.compile(sourceFilePath, CompilerPhase.CODE_GEN);
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException(compileResult.toString());
        }
        BLangProgramRunner.runProgram((ProgramFile)compileResult.getProgFile(), (BValue[])new BValue[0]);
        return compileResult;
    }

    public static CompileResult compileAndSetup(Object obj, String sourceRoot, String packageName) {
        CompileResult compileResult = BCompileUtil.compile(obj, sourceRoot, packageName);
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException(compileResult.toString());
        }
        BLangProgramRunner.runProgram((ProgramFile)compileResult.getProgFile(), (BValue[])new BValue[0]);
        return compileResult;
    }

    public static CompileResult compileAndGetBIR(String sourceFilePath) {
        return BCompileUtil.compile(sourceFilePath, CompilerPhase.BIR_GEN);
    }

    public static CompileResult compile(String sourceFilePath) {
        return BCompileUtil.compile(sourceFilePath, CompilerPhase.CODE_GEN);
    }

    public static CompileResult compileWithoutExperimentalFeatures(String sourceFilePath) {
        return BCompileUtil.compile(sourceFilePath, CompilerPhase.CODE_GEN, false);
    }

    public static CompileResult compile(String sourceFilePath, boolean isSiddhiRuntimeEnabled) {
        Path sourcePath = Paths.get(sourceFilePath, new String[0]);
        String packageName = sourcePath.getFileName().toString();
        Path sourceRoot = resourceDir.resolve(sourcePath.getParent());
        return BCompileUtil.compile(sourceRoot.toString(), packageName, CompilerPhase.CODE_GEN, isSiddhiRuntimeEnabled, true);
    }

    public static CompileResult compile(String sourceRoot, String packageName) {
        Path rootPath = Paths.get(sourceRoot, new String[0]);
        Path packagePath = Paths.get(packageName, new String[0]);
        return BCompileUtil.getCompileResult(packageName, rootPath, packagePath);
    }

    public static CompileResult compile(Object obj, String sourceRoot, String packageName) {
        String filePath = BCompileUtil.concatFileName(sourceRoot, resourceDir);
        Path rootPath = Paths.get(filePath, new String[0]);
        Path packagePath = Paths.get(packageName, new String[0]);
        return BCompileUtil.getCompileResult(packageName, rootPath, packagePath);
    }

    private static CompileResult getCompileResult(String packageName, Path rootPath, Path packagePath) {
        if (Files.isDirectory(packagePath, new LinkOption[0])) {
            String[] pkgParts = packageName.split("\\/");
            List pkgNameComps = Arrays.stream(pkgParts).map(part -> {
                if (part.equals("")) {
                    return Names.EMPTY;
                }
                if (part.equals("_")) {
                    return Names.EMPTY;
                }
                return new Name(part);
            }).collect(Collectors.toList());
            PackageID pkgId = new PackageID(Names.ANON_ORG, pkgNameComps, Names.DEFAULT_VERSION);
            String effectiveSource = pkgId.getName().getValue();
            return BCompileUtil.compile(rootPath.toString(), effectiveSource, CompilerPhase.CODE_GEN);
        }
        String effectiveSource = packageName;
        return BCompileUtil.compile(rootPath.toString(), effectiveSource, CompilerPhase.CODE_GEN, (SourceDirectory)new FileSystemProjectDirectory(rootPath));
    }

    public static String concatFileName(String fileName, Path pathLocation) {
        String windowsFolderSeparator = "\\";
        String unixFolderSeparator = "/";
        StringBuilder path = new StringBuilder(pathLocation.toAbsolutePath().toString());
        path = pathLocation.endsWith("\\") ? path.append("\\").append(fileName) : path.append("/").append(fileName);
        return path.toString();
    }

    public static CompileResult compile(String sourceFilePath, CompilerPhase compilerPhase, boolean enableExpFeatures) {
        Path sourcePath = Paths.get(sourceFilePath, new String[0]);
        String packageName = sourcePath.getFileName().toString();
        Path sourceRoot = resourceDir.resolve(sourcePath.getParent());
        return BCompileUtil.compile(sourceRoot.toString(), packageName, compilerPhase, enableExpFeatures);
    }

    public static CompileResult compile(String sourceFilePath, CompilerPhase compilerPhase) {
        return BCompileUtil.compile(sourceFilePath, compilerPhase, true);
    }

    public static CompileResult compile(String sourceRoot, String packageName, CompilerPhase compilerPhase, boolean enableExpFeatures) {
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRoot);
        options.put(CompilerOptionName.COMPILER_PHASE, compilerPhase.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(enableExpFeatures));
        return BCompileUtil.compile(context, packageName, compilerPhase, false);
    }

    public static CompileResult compile(String sourceRoot, String packageName, CompilerPhase compilerPhase, boolean isSiddhiRuntimeEnabled, boolean enableExpFeatures) {
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRoot);
        options.put(CompilerOptionName.COMPILER_PHASE, compilerPhase.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        options.put(CompilerOptionName.SIDDHI_RUNTIME_ENABLED, Boolean.toString(isSiddhiRuntimeEnabled));
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(enableExpFeatures));
        return BCompileUtil.compile(context, packageName, compilerPhase, false);
    }

    public static CompileResult compile(String sourceRoot, String packageName, CompilerPhase compilerPhase) {
        return BCompileUtil.compile(sourceRoot, packageName, compilerPhase, true);
    }

    public static CompileResult compileWithTests(CompilerContext context, CompileResult.CompileResultDiagnosticListener listener, String packageName, CompilerPhase compilerPhase) {
        return BCompileUtil.compile(context, listener, packageName, compilerPhase, true);
    }

    public static CompilerContext createCompilerContext(String sourceRoot, CompilerPhase compilerPhase) {
        return BCompileUtil.createCompilerContext(sourceRoot, compilerPhase, Boolean.TRUE);
    }

    public static CompilerContext createCompilerContext(String sourceRoot, CompilerPhase compilerPhase, boolean enableExpFeatures) {
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRoot);
        options.put(CompilerOptionName.COMPILER_PHASE, compilerPhase.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        options.put(CompilerOptionName.TEST_ENABLED, "true");
        options.put(CompilerOptionName.SKIP_TESTS, "false");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(enableExpFeatures));
        return context;
    }

    public static CompileResult compile(String sourceRoot, String packageName, CompilerPhase compilerPhase, SourceDirectory sourceDirectory) {
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRoot);
        options.put(CompilerOptionName.COMPILER_PHASE, compilerPhase.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.TRUE.toString());
        context.put(SourceDirectory.class, (Object)sourceDirectory);
        CompileResult.CompileResultDiagnosticListener listener = new CompileResult.CompileResultDiagnosticListener();
        context.put(DiagnosticListener.class, (Object)listener);
        CompileResult comResult = new CompileResult(listener);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        BLangPackage packageNode = compiler.compile(packageName);
        comResult.setAST((PackageNode)packageNode);
        CompiledBinaryFile.ProgramFile programFile = compiler.getExecutableProgram(packageNode);
        if (programFile != null) {
            comResult.setProgFile(LauncherUtils.getExecutableProgram(programFile));
        }
        return comResult;
    }

    private static CompileResult compile(CompilerContext context, String packageName, CompilerPhase compilerPhase, boolean withTests) {
        CompileResult.CompileResultDiagnosticListener listener = new CompileResult.CompileResultDiagnosticListener();
        context.put(DiagnosticListener.class, (Object)listener);
        return BCompileUtil.compile(context, listener, packageName, compilerPhase, withTests);
    }

    private static CompileResult compile(CompilerContext context, CompileResult.CompileResultDiagnosticListener listener, String packageName, CompilerPhase compilerPhase, boolean withTests) {
        CompileResult comResult = new CompileResult(listener);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        BLangPackage packageNode = compiler.compile(packageName, true);
        comResult.setAST((PackageNode)packageNode);
        if (comResult.getErrorCount() > 0) {
            return comResult;
        }
        if (CompilerPhase.CODE_GEN.compareTo((Enum)compilerPhase) > 0 || compilerPhase == CompilerPhase.BIR_GEN) {
            return comResult;
        }
        CompiledBinaryFile.ProgramFile programFile = withTests && packageNode.containsTestablePkg() ? compiler.getExecutableProgram((BLangPackage)packageNode.getTestablePkg()) : compiler.getExecutableProgram(packageNode);
        if (programFile != null) {
            ProgramFile pFile = LauncherUtils.getExecutableProgram(programFile);
            pFile.setProgramFilePath(Paths.get(packageName, new String[0]));
            comResult.setProgFile(pFile);
        }
        return comResult;
    }

    public static BLangPackage compileAndGetPackage(String sourceFilePath) {
        Path sourcePath = Paths.get(sourceFilePath, new String[0]);
        String packageName = sourcePath.getFileName().toString();
        Path sourceRoot = resourceDir.resolve(sourcePath.getParent());
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, resourceDir.resolve(sourceRoot).toString());
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.TRUE.toString());
        CompileResult.CompileResultDiagnosticListener listener = new CompileResult.CompileResultDiagnosticListener();
        context.put(DiagnosticListener.class, (Object)listener);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        return compiler.compile(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String path) throws IOException {
        InputStream is = ClassLoader.getSystemResourceAsStream(path);
        InputStreamReader inputStreamREader = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            inputStreamREader = new InputStreamReader(is, StandardCharsets.UTF_8);
            br = new BufferedReader(inputStreamREader);
            String content = br.readLine();
            if (content == null) {
                String string = sb.toString();
                return string;
            }
            sb.append(content);
            while ((content = br.readLine()) != null) {
                sb.append('\n').append(content);
            }
        }
        finally {
            if (inputStreamREader != null) {
                try {
                    inputStreamREader.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static BMap<String, BValue> createAndGetStruct(ProgramFile programFile, String packagePath, String structName) {
        PackageInfo structPackageInfo = programFile.getPackageInfo(packagePath);
        StructureTypeInfo typeInfo = structPackageInfo.getStructInfo(structName);
        return BLangVMStructs.createBStruct((StructureTypeInfo)typeInfo, (Object[])new Object[0]);
    }

    public static List<Diagnostic> getDiagnostics(ClassLoader classLoader, String sourceRoot, String fileName) {
        Thread.currentThread().setContextClassLoader(classLoader);
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRoot);
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.TRUE.toString());
        CompileResult.CompileResultDiagnosticListener listener = new CompileResult.CompileResultDiagnosticListener();
        context.put(DiagnosticListener.class, (Object)listener);
        CompileResult comResult = new CompileResult(listener);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        BLangPackage entryPackageNode = compiler.compile(fileName);
        CompiledBinaryFile.ProgramFile programFile = compiler.getExecutableProgram(entryPackageNode);
        if (programFile != null) {
            comResult.setProgFile(LauncherUtils.getExecutableProgram(programFile));
        }
        Diagnostic[] diagnostics = comResult.getDiagnostics();
        return Arrays.stream(diagnostics).collect(Collectors.toList());
    }
}

