/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import org.ballerinalang.BLangProgramRunner;
import org.ballerinalang.bre.bvm.BVMExecutor;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.tool.util.CompileResult;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.debugger.Debugger;

public class BRunUtil {
    public static BValue[] invokeStateful(CompileResult compileResult, String functionName) {
        BValue[] args = new BValue[]{};
        return BRunUtil.invokeStateful(compileResult, functionName, args);
    }

    public static BValue[] invokeStateful(CompileResult compileResult, String functionName, BValue[] args) {
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException(compileResult.toString());
        }
        return BRunUtil.invokeStateful(compileResult, compileResult.getProgFile().getEntryPkgName(), functionName, args);
    }

    public static BValue[] invokeStateful(CompileResult compileResult, String packageName, String functionName) {
        BValue[] args = new BValue[]{};
        return BRunUtil.invokeStateful(compileResult, packageName, functionName, args);
    }

    public static BValue[] invokeStateful(CompileResult compileResult, String packageName, String functionName, BValue[] args) {
        int providedArgNo;
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException(compileResult.toString());
        }
        ProgramFile programFile = compileResult.getProgFile();
        Debugger debugger = new Debugger(programFile);
        programFile.setDebugger(debugger);
        PackageInfo packageInfo = programFile.getPackageInfo(packageName);
        FunctionInfo functionInfo = packageInfo.getFunctionInfo(functionName);
        if (functionInfo == null) {
            throw new RuntimeException("Function '" + functionName + "' is not defined");
        }
        int requiredArgNo = functionInfo.getParamTypes().length;
        if (requiredArgNo != (providedArgNo = args.length)) {
            throw new RuntimeException("Wrong number of arguments. Required: " + requiredArgNo + " , found: " + providedArgNo + ".");
        }
        BValue[] response = BVMExecutor.executeFunction((ProgramFile)programFile, (FunctionInfo)functionInfo, (BValue[])args);
        return BRunUtil.spreadToBValueArray(response);
    }

    public static BValue[] invoke(CompileResult compileResult, String packageName, String functionName, BValue[] args) {
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException(compileResult.toString());
        }
        ProgramFile programFile = compileResult.getProgFile();
        PackageInfo packageInfo = programFile.getPackageInfo(packageName);
        FunctionInfo functionInfo = packageInfo.getFunctionInfo(functionName);
        if (functionInfo == null) {
            throw new RuntimeException("Function '" + functionName + "' is not defined");
        }
        BValue[] response = new BValue[]{BLangProgramRunner.runProgram((ProgramFile)programFile, (FunctionInfo)functionInfo, (BValue[])args)};
        return BRunUtil.spreadToBValueArray(response);
    }

    public static BValue[] invoke(CompileResult compileResult, String packageName, String functionName) {
        BValue[] args = new BValue[]{};
        return BRunUtil.invoke(compileResult, packageName, functionName, args);
    }

    public static BValue[] invoke(CompileResult compileResult, String functionName, BValue[] args) {
        BValue[] response = BRunUtil.invokeFunction(compileResult, functionName, args);
        return BRunUtil.spreadToBValueArray(response);
    }

    public static BValue[] invokeFunction(CompileResult compileResult, String functionName, BValue[] args) {
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException(compileResult.toString());
        }
        ProgramFile programFile = compileResult.getProgFile();
        PackageInfo packageInfo = programFile.getPackageInfo(programFile.getEntryPkgName());
        FunctionInfo functionInfo = packageInfo.getFunctionInfo(functionName);
        if (functionInfo == null) {
            throw new RuntimeException("Function '" + functionName + "' is not defined");
        }
        return new BValue[]{BLangProgramRunner.runProgram((ProgramFile)programFile, (FunctionInfo)functionInfo, (BValue[])args)};
    }

    public static BValue[] invokeFunction(CompileResult compileResult, String functionName) {
        return BRunUtil.invokeFunction(compileResult, functionName, new BValue[0]);
    }

    private static BValue[] spreadToBValueArray(BValue[] response) {
        if (response == null || response.length <= 0 || !(response[0] instanceof BValueArray)) {
            return response;
        }
        BValueArray refValueArray = (BValueArray)response[0];
        BType elementType = refValueArray.elementType;
        if (elementType == BTypes.typeString || elementType == BTypes.typeInt || elementType == BTypes.typeFloat || elementType == BTypes.typeBoolean || elementType == BTypes.typeByte) {
            return response;
        }
        int length = (int)refValueArray.size();
        BValue[] arr = new BValue[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = refValueArray.getRefValue((long)i);
        }
        return arr;
    }

    public static BValue[] invoke(CompileResult compileResult, String functionName) {
        BValue[] args = new BValue[]{};
        return BRunUtil.invoke(compileResult, functionName, args);
    }

    public static void invoke(CompileResult compileResult, FunctionInfo initFuncInfo, WorkerExecutionContext context) {
        Debugger debugger = new Debugger(compileResult.getProgFile());
        compileResult.getProgFile().setDebugger(debugger);
        BVMExecutor.executeFunction((ProgramFile)compileResult.getProgFile(), (FunctionInfo)initFuncInfo, (BValue[])new BValue[0]);
    }
}

