/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.values.MapValue;

public class ToolUtil {
    private static final String STAGING_URL = "https://api.staging-central.ballerina.io/";

    public static void listSDKs(PrintStream outStream) {
        try {
            MapValue distributions = ToolUtil.getDistributions();
            for (int i = 0; i < distributions.getArrayValue("list").size(); ++i) {
                MapValue dist = (MapValue)distributions.getArrayValue("list").get((long)i);
                outStream.print(dist.getStringValue("type") + " - " + dist.getStringValue("version") + "\n");
            }
        }
        catch (IOException e) {
            outStream.println("Ballerina Update service is not available");
        }
    }

    public static void install(PrintStream outStream, String version) {
        outStream.println("Ballerina Update service is not available");
    }

    public static void update(PrintStream outStream, String currentVersion) {
        outStream.println("Ballerina Update service is not available");
    }

    public static void remove(PrintStream outStream, String version) {
        outStream.println("Ballerina Update service is not available");
    }

    private static MapValue getDistributions() throws IOException {
        URL url = new URL("https://api.staging-central.ballerina.io//distributions");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("user-agent", "jBallerina/0.992.0 (win-64) Updater/1.0");
        conn.setRequestProperty("Accept", "application/json");
        if (conn.getResponseCode() != 200) {
            conn.disconnect();
            throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
        }
        JSONParser parser = new JSONParser();
        MapValue distributions = (MapValue)JSONParser.parse((Reader)new InputStreamReader(conn.getInputStream()));
        conn.disconnect();
        return distributions;
    }

    private static MapValue getDistribution(String version) throws IOException {
        URL url = new URL("https://api.staging-central.ballerina.io//update-tool/distributions/" + version);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("user-agent", "jBallerina/0.992.0 (win-64) Updater/1.0");
        conn.setRequestProperty("Accept", "application/json");
        if (conn.getResponseCode() != 200) {
            conn.disconnect();
            throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
        }
        JSONParser parser = new JSONParser();
        MapValue distributions = (MapValue)JSONParser.parse((Reader)new InputStreamReader(conn.getInputStream()));
        conn.disconnect();
        return distributions;
    }
}

