/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticListener;

public class CompileResult {
    private PackageNode pkgNode;
    private CompileResultDiagnosticListener diagnosticListener;

    public CompileResult(CompileResultDiagnosticListener diagnosticListener) {
        this.diagnosticListener = diagnosticListener;
    }

    public Diagnostic[] getDiagnostics() {
        List<Diagnostic> diagnostics = this.diagnosticListener.getDiagnostics();
        diagnostics.sort(Comparator.comparing(d -> d.getSource().getCompilationUnitName()).thenComparingInt(d -> d.getPosition().getStartLine()));
        return diagnostics.toArray(new Diagnostic[diagnostics.size()]);
    }

    public int getErrorCount() {
        return this.diagnosticListener.errorCount;
    }

    public int getWarnCount() {
        return this.diagnosticListener.warnCount;
    }

    public PackageNode getAST() {
        return this.pkgNode;
    }

    public void setAST(PackageNode pkgNode) {
        this.pkgNode = pkgNode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.diagnosticListener.errorCount == 0) {
            builder.append("Compilation Successful");
        } else {
            builder.append("Compilation Failed:\n");
            for (Diagnostic diag : this.getDiagnostics()) {
                builder.append(diag + "\n");
            }
        }
        return builder.toString();
    }

    public static class CompileResultDiagnosticListener
    implements DiagnosticListener {
        private List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        private int errorCount = 0;
        private int warnCount = 0;

        public void received(Diagnostic diagnostic) {
            this.diagnostics.add(diagnostic);
            switch (diagnostic.getKind()) {
                case ERROR: {
                    ++this.errorCount;
                    break;
                }
                case WARNING: {
                    ++this.warnCount;
                    break;
                }
            }
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public int getWarnCount() {
            return this.warnCount;
        }

        public List<Diagnostic> getDiagnostics() {
            Collections.sort(this.diagnostics);
            return this.diagnostics;
        }
    }
}

