/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.langlib.typedesc.ConstructFrom;
import org.ballerinalang.net.http.BallerinaHTTPConnectorListener;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpConstants;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.uri.URIUtil;
import org.ballerinalang.net.websub.WebSubDispatcher;
import org.ballerinalang.net.websub.WebSubEmptyCallableUnitCallback;
import org.ballerinalang.net.websub.WebSubServicesRegistry;
import org.ballerinalang.net.websub.WebSubSubscriberConstants;
import org.ballerinalang.net.websub.WebSubUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class BallerinaWebSubConnectorListener
extends BallerinaHTTPConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(BallerinaWebSubConnectorListener.class);
    private WebSubServicesRegistry webSubServicesRegistry;
    private PrintStream console = System.out;
    private Scheduler scheduler;

    public BallerinaWebSubConnectorListener(Strand strand, WebSubServicesRegistry webSubServicesRegistry, MapValue endpointConfig) {
        super((HTTPServicesRegistry)webSubServicesRegistry, endpointConfig);
        this.scheduler = strand.scheduler;
        this.webSubServicesRegistry = webSubServicesRegistry;
    }

    public void onMessage(HttpCarbonMessage inboundMessage) {
        try {
            if (this.accessed(inboundMessage)) {
                HttpResource httpResource;
                if (inboundMessage.getProperty("httpResource") instanceof String) {
                    if (inboundMessage.getProperty("httpResource").equals("annotatedTopic")) {
                        this.autoRespondToIntentVerification(inboundMessage);
                        return;
                    }
                    httpResource = WebSubDispatcher.findResource(this.webSubServicesRegistry, inboundMessage);
                } else {
                    httpResource = (HttpResource)inboundMessage.getProperty("httpResource");
                }
                this.extractPropertiesAndStartResourceExecution(inboundMessage, httpResource);
                return;
            }
            HttpResource httpResource = WebSubDispatcher.findResource(this.webSubServicesRegistry, inboundMessage);
            if (inboundMessage.getProperty("httpResource") == null) {
                inboundMessage.setProperty("httpResource", (Object)httpResource);
                return;
            }
            if (inboundMessage.getProperty("httpResource") instanceof String) {
                return;
            }
            this.extractPropertiesAndStartResourceExecution(inboundMessage, httpResource);
        }
        catch (BallerinaException ex) {
            try {
                HttpUtil.handleFailure((HttpCarbonMessage)inboundMessage, (BallerinaConnectorException)new BallerinaConnectorException(ex.getMessage(), ex.getCause()));
            }
            catch (Exception e) {
                log.error("Cannot handle error using the error handler for: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void extractPropertiesAndStartResourceExecution(HttpCarbonMessage httpCarbonMessage, HttpResource httpResource) {
        int paramIndex = 0;
        ObjectValue httpRequest = httpCarbonMessage.getProperty("entityAccessedRequest") != null ? (ObjectValue)httpCarbonMessage.getProperty("entityAccessedRequest") : WebSubUtils.getHttpRequest(httpCarbonMessage);
        AttachedFunction balResource = httpResource.getBalResource();
        List paramTypes = httpResource.getParamTypes();
        Object[] signatureParams = new Object[paramTypes.size() * 2];
        String resourceName = httpResource.getName();
        if ("onIntentVerification".equals(resourceName)) {
            signatureParams[paramIndex++] = this.getWebSubCaller(httpResource, httpCarbonMessage, this.endpointConfig);
            signatureParams[paramIndex++] = true;
            ObjectValue intentVerificationRequest = this.createIntentVerificationRequest();
            if (httpCarbonMessage.getProperty("QUERY_STR") != null) {
                String queryString = (String)httpCarbonMessage.getProperty("QUERY_STR");
                MapValueImpl params = new MapValueImpl();
                try {
                    URIUtil.populateQueryParamMap((String)queryString, (MapValue)params);
                    intentVerificationRequest.set("mode", (Object)this.getParamStringValue((MapValue<String, Object>)params, "hub.mode"));
                    intentVerificationRequest.set("topic", (Object)this.getParamStringValue((MapValue<String, Object>)params, "hub.topic"));
                    intentVerificationRequest.set("challenge", (Object)this.getParamStringValue((MapValue<String, Object>)params, "hub.challenge"));
                    if (params.containsKey((Object)"hub.lease_seconds")) {
                        long leaseSec = Long.parseLong(this.getParamStringValue((MapValue<String, Object>)params, "hub.lease_seconds"));
                        intentVerificationRequest.set("leaseSeconds", (Object)leaseSec);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Error populating query map for intent verification request received: " + e.getMessage());
                    HttpCarbonMessage response = HttpUtil.createHttpCarbonMessage((boolean)false);
                    response.waitAndReleaseAllEntities();
                    response.setHttpStatusCode(Integer.valueOf(HttpResponseStatus.NOT_FOUND.code()));
                    response.addHttpContent((HttpContent)new DefaultLastHttpContent());
                    HttpUtil.sendOutboundResponse((HttpCarbonMessage)httpCarbonMessage, (HttpCarbonMessage)response);
                    return;
                }
            }
            intentVerificationRequest.set("request", (Object)httpRequest);
            signatureParams[paramIndex++] = intentVerificationRequest;
            signatureParams[paramIndex] = true;
        } else {
            this.validateSignature(httpCarbonMessage, httpResource, httpRequest);
            HttpCarbonMessage response = HttpUtil.createHttpCarbonMessage((boolean)false);
            response.waitAndReleaseAllEntities();
            response.setHttpStatusCode(Integer.valueOf(HttpResponseStatus.ACCEPTED.code()));
            response.addHttpContent((HttpContent)new DefaultLastHttpContent());
            HttpUtil.sendOutboundResponse((HttpCarbonMessage)httpCarbonMessage, (HttpCarbonMessage)response);
            signatureParams[paramIndex++] = this.createNotification(httpRequest);
            signatureParams[paramIndex++] = true;
            if (!"onNotification".equals(balResource.getName())) {
                Object customRecordOrError = this.createCustomNotification(httpCarbonMessage, balResource, httpRequest);
                if (TypeChecker.getType((Object)customRecordOrError).getTag() == 29) {
                    log.error("Data binding failed: " + ((ErrorValue)customRecordOrError).getPrintableStackTrace());
                    return;
                }
                signatureParams[paramIndex++] = customRecordOrError;
                signatureParams[paramIndex] = true;
            }
        }
        WebSubEmptyCallableUnitCallback callback = new WebSubEmptyCallableUnitCallback();
        ObjectValue service = httpResource.getParentService().getBalService();
        Executor.submit((Scheduler)this.scheduler, (ObjectValue)service, (String)balResource.getName(), (CallableUnitCallback)callback, null, (Object[])signatureParams);
    }

    private void validateSignature(HttpCarbonMessage httpCarbonMessage, HttpResource httpResource, ObjectValue request) {
        Object returnValue;
        try {
            Object[] args = new Object[]{request, httpResource.getParentService().getBalService()};
            returnValue = Executor.executeFunction((Scheduler)this.scheduler, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ballerina", (String)"websub", (String)"commons", (String)"processWebSubNotification", (Object[])args);
        }
        catch (BallerinaException ex) {
            log.debug("Signature Validation failed: " + ex.getMessage());
            httpCarbonMessage.setHttpStatusCode(Integer.valueOf(404));
            throw ex;
        }
        ErrorValue error = (ErrorValue)returnValue;
        if (error != null) {
            log.debug("Signature Validation failed for Notification: " + ((MapValue)error.getDetails()).getStringValue("message"));
            httpCarbonMessage.setHttpStatusCode(Integer.valueOf(404));
            throw new BallerinaException("validation failed for notification");
        }
    }

    private ObjectValue getWebSubCaller(HttpResource httpResource, HttpCarbonMessage httpCarbonMessage, MapValue endpointConfig) {
        ObjectValue httpServiceServer = BallerinaValues.createObjectValue((BPackage)HttpConstants.PROTOCOL_HTTP_PKG_ID, (String)"Listener", (Object[])new Object[]{9090, endpointConfig});
        ObjectValue httpCaller = BallerinaValues.createObjectValue((BPackage)HttpConstants.PROTOCOL_HTTP_PKG_ID, (String)"Caller", (Object[])new Object[0]);
        HttpUtil.enrichHttpCallerWithConnectionInfo((ObjectValue)httpCaller, (HttpCarbonMessage)httpCarbonMessage, (HttpResource)httpResource, (MapValue)endpointConfig);
        HttpUtil.enrichHttpCallerWithNativeData((ObjectValue)httpCaller, (HttpCarbonMessage)httpCarbonMessage, (MapValue)endpointConfig);
        httpServiceServer.addNativeData("caller", (Object)httpCaller);
        return BallerinaValues.createObjectValue((BPackage)WebSubSubscriberConstants.WEBSUB_PACKAGE_ID, (String)"Caller", (Object[])new Object[]{httpCaller});
    }

    private ObjectValue createIntentVerificationRequest() {
        return BallerinaValues.createObjectValue((BPackage)WebSubSubscriberConstants.WEBSUB_PACKAGE_ID, (String)"IntentVerificationRequest", (Object[])new Object[0]);
    }

    private ObjectValue createNotification(ObjectValue httpRequest) {
        ObjectValue notification = BallerinaValues.createObjectValue((BPackage)WebSubSubscriberConstants.WEBSUB_PACKAGE_ID, (String)"Notification", (Object[])new Object[0]);
        notification.set("request", (Object)httpRequest);
        return notification;
    }

    private Object createCustomNotification(HttpCarbonMessage inboundRequest, AttachedFunction resource, ObjectValue httpRequest) {
        BRecordType recordType = this.webSubServicesRegistry.getResourceDetails().get(resource.getName());
        MapValue<String, ?> jsonBody = WebSubUtils.getJsonBody(httpRequest);
        inboundRequest.setProperty("entityAccessedRequest", (Object)httpRequest);
        return ConstructFrom.convert((BType)recordType, jsonBody);
    }

    private void autoRespondToIntentVerification(HttpCarbonMessage httpCarbonMessage) {
        HttpCarbonMessage response = HttpUtil.createHttpCarbonMessage((boolean)false);
        response.waitAndReleaseAllEntities();
        if (httpCarbonMessage.getProperty("annotatedTopic") == null) {
            this.console.println("ballerina: Intent Verification denied - expected topic details not found");
            BallerinaWebSubConnectorListener.sendIntentVerificiationDenialResponse(httpCarbonMessage, response);
            return;
        }
        if (httpCarbonMessage.getProperty("QUERY_STR") == null) {
            this.console.println("ballerina: Intent Verification denied - invalid intent verification request");
            BallerinaWebSubConnectorListener.sendIntentVerificiationDenialResponse(httpCarbonMessage, response);
            return;
        }
        String annotatedTopic = httpCarbonMessage.getProperty("annotatedTopic").toString();
        String queryString = (String)httpCarbonMessage.getProperty("QUERY_STR");
        MapValueImpl params = new MapValueImpl();
        try {
            URIUtil.populateQueryParamMap((String)queryString, (MapValue)params);
            if (!(params.containsKey((Object)"hub.mode") && params.containsKey((Object)"hub.topic") && params.containsKey((Object)"hub.challenge"))) {
                BallerinaWebSubConnectorListener.sendIntentVerificiationDenialResponse(httpCarbonMessage, response);
                this.console.println("error: Error auto-responding to intent verification request: Mode, Topic and/or challenge not specified");
                return;
            }
            String mode = this.getParamStringValue((MapValue<String, Object>)params, "hub.mode");
            if (("subscribe".equals(mode) || "unsubscribe".equals(mode)) && annotatedTopic.equals(this.getParamStringValue((MapValue<String, Object>)params, "hub.topic"))) {
                String challenge = this.getParamStringValue((MapValue<String, Object>)params, "hub.challenge");
                response.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])challenge.getBytes(StandardCharsets.UTF_8))));
                response.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), "text/plain");
                response.setHttpStatusCode(Integer.valueOf(HttpResponseStatus.ACCEPTED.code()));
                String intentVerificationMessage = "ballerina: Intent Verification agreed - Mode [" + mode + "], Topic [" + annotatedTopic + "]";
                if (params.containsKey((Object)"hub.lease_seconds")) {
                    intentVerificationMessage = intentVerificationMessage.concat(", Lease Seconds [" + this.getParamStringValue((MapValue<String, Object>)params, "hub.lease_seconds") + "]");
                }
                this.console.println(intentVerificationMessage);
                HttpUtil.sendOutboundResponse((HttpCarbonMessage)httpCarbonMessage, (HttpCarbonMessage)response);
            } else {
                this.console.println("ballerina: Intent Verification denied - Mode [" + mode + "], Topic [" + this.getParamStringValue((MapValue<String, Object>)params, "hub.topic") + "]");
                BallerinaWebSubConnectorListener.sendIntentVerificiationDenialResponse(httpCarbonMessage, response);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.console.println("ballerina: Intent Verification denied - error extracting query parameters: " + e.getMessage());
            BallerinaWebSubConnectorListener.sendIntentVerificiationDenialResponse(httpCarbonMessage, response);
        }
    }

    private static void sendIntentVerificiationDenialResponse(HttpCarbonMessage httpCarbonMessage, HttpCarbonMessage response) {
        response.setHttpStatusCode(Integer.valueOf(HttpResponseStatus.NOT_FOUND.code()));
        response.addHttpContent((HttpContent)new DefaultLastHttpContent());
        HttpUtil.sendOutboundResponse((HttpCarbonMessage)httpCarbonMessage, (HttpCarbonMessage)response);
    }

    private String getParamStringValue(MapValue<String, Object> params, String key) {
        if (!params.containsKey((Object)key)) {
            return "";
        }
        Object param = params.get((Object)key);
        if (TypeChecker.getType((Object)param).getTag() != 20 || ((ArrayValue)param).size() < 1) {
            return "";
        }
        return ((ArrayValue)param).get(0L).toString();
    }
}

