/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.websub.WebSubHttpService;
import org.ballerinalang.net.websub.WebSubServicesRegistry;
import org.ballerinalang.net.websub.WebSubUtils;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

class WebSubResourceDispatcher {
    WebSubResourceDispatcher() {
    }

    static HttpResource findResource(HttpService service, HttpCarbonMessage inboundRequest, WebSubServicesRegistry servicesRegistry) throws BallerinaConnectorException, ServerConnectorException {
        String resourceName;
        String method = inboundRequest.getHttpMethod();
        HttpResource httpResource = null;
        String topicIdentifier = servicesRegistry.getTopicIdentifier();
        if ("TOPIC_ID_HEADER".equals(topicIdentifier) && "POST".equals(method)) {
            String topic = inboundRequest.getHeader(servicesRegistry.getTopicHeader());
            resourceName = WebSubResourceDispatcher.retrieveResourceName(topic, servicesRegistry.getHeaderResourceMap());
        } else if (topicIdentifier != null && "POST".equals(method)) {
            if (inboundRequest.getProperty("httpResource") == null) {
                inboundRequest.setProperty("httpResource", (Object)"deferredForPayloadBasedDispatching");
                return null;
            }
            resourceName = topicIdentifier.equals("TOPIC_ID_PAYLOAD_KEY") ? WebSubResourceDispatcher.retrieveResourceName(inboundRequest, servicesRegistry.getPayloadKeyResourceMap()) : WebSubResourceDispatcher.retrieveResourceName(inboundRequest, servicesRegistry);
        } else {
            resourceName = WebSubResourceDispatcher.retrieveResourceName(method);
        }
        for (HttpResource resource : service.getResources()) {
            if (!resource.getName().equals(resourceName)) continue;
            httpResource = resource;
            break;
        }
        if (httpResource == null) {
            if ("onIntentVerification".equals(resourceName)) {
                Object target = ((MapValue)service.getBalService().getType().getAnnotation("ballerina/websub", "SubscriberServiceConfig")).get((Object)"target");
                String annotatedTopic = "";
                if (target instanceof ArrayValue) {
                    annotatedTopic = ((ArrayValue)target).getString(1L);
                }
                if (annotatedTopic.isEmpty() && service instanceof WebSubHttpService) {
                    annotatedTopic = ((WebSubHttpService)service).getTopic();
                }
                inboundRequest.setProperty("annotatedTopic", (Object)annotatedTopic);
                inboundRequest.setProperty("httpResource", (Object)"annotatedTopic");
            } else {
                inboundRequest.setHttpStatusCode(Integer.valueOf(404));
                throw new BallerinaConnectorException("no matching WebSub Subscriber service  resource " + resourceName + " found for method : " + method);
            }
        }
        return httpResource;
    }

    private static String retrieveResourceName(String method) {
        switch (method) {
            case "POST": {
                return "onNotification";
            }
            case "GET": {
                return "onIntentVerification";
            }
        }
        throw new BallerinaConnectorException("method not allowed for WebSub Subscriber Services : " + method);
    }

    private static String retrieveResourceName(HttpCarbonMessage inboundRequest, WebSubServicesRegistry servicesRegistry) {
        MapValue<String, MapValue<String, Object>> payloadKeyResourceMap;
        String resourceName;
        MapValue<String, Object> headerResourceMap;
        MapValue<String, MapValue<String, MapValue<String, Object>>> headerAndPayloadKeyResourceMap = servicesRegistry.getHeaderAndPayloadKeyResourceMap();
        String topic = inboundRequest.getHeader(servicesRegistry.getTopicHeader());
        ObjectValue httpRequest = WebSubUtils.getHttpRequest(inboundRequest);
        MapValue<String, ?> jsonBody = WebSubUtils.getJsonBody(httpRequest);
        inboundRequest.setProperty("entityAccessedRequest", (Object)httpRequest);
        if (headerAndPayloadKeyResourceMap.containsKey((Object)topic)) {
            MapValue topicResourceMapForHeader = (MapValue)headerAndPayloadKeyResourceMap.get((Object)topic);
            for (String key : (String[])topicResourceMapForHeader.getKeys()) {
                String valueForKey;
                MapValue topicResourceMapForValue;
                if (!jsonBody.containsKey((Object)key) || !(topicResourceMapForValue = (MapValue)topicResourceMapForHeader.get((Object)key)).containsKey((Object)(valueForKey = jsonBody.get((Object)key).toString()))) continue;
                return WebSubResourceDispatcher.retrieveResourceName(valueForKey, (MapValue<String, Object>)topicResourceMapForValue);
            }
        }
        if (servicesRegistry.getHeaderResourceMap() != null && (headerResourceMap = servicesRegistry.getHeaderResourceMap()).containsKey((Object)topic)) {
            return WebSubResourceDispatcher.retrieveResourceName(topic, headerResourceMap);
        }
        if (servicesRegistry.getPayloadKeyResourceMap() != null && (resourceName = WebSubResourceDispatcher.retrieveResourceNameForKey(jsonBody, payloadKeyResourceMap = servicesRegistry.getPayloadKeyResourceMap())) != null) {
            return resourceName;
        }
        throw new BallerinaConnectorException("Matching resource not found for dispatching based on Header and Payload Key");
    }

    private static String retrieveResourceName(HttpCarbonMessage inboundRequest, MapValue<String, MapValue<String, Object>> payloadKeyResourceMap) {
        ObjectValue httpRequest = WebSubUtils.getHttpRequest(inboundRequest);
        MapValue<String, ?> jsonBody = WebSubUtils.getJsonBody(httpRequest);
        inboundRequest.setProperty("entityAccessedRequest", (Object)httpRequest);
        String resourceName = WebSubResourceDispatcher.retrieveResourceNameForKey(jsonBody, payloadKeyResourceMap);
        if (resourceName != null) {
            return resourceName;
        }
        throw new BallerinaConnectorException("Matching resource not found for dispatching based on Payload Key");
    }

    private static String retrieveResourceNameForKey(MapValue<String, ?> jsonBody, MapValue<String, MapValue<String, Object>> payloadKeyResourceMap) {
        for (String key : (String[])payloadKeyResourceMap.getKeys()) {
            String valueForKey;
            MapValue topicResourceMapForValue;
            if (!jsonBody.containsKey((Object)key) || !(topicResourceMapForValue = (MapValue)payloadKeyResourceMap.get((Object)key)).containsKey((Object)(valueForKey = jsonBody.get((Object)key).toString()))) continue;
            return WebSubResourceDispatcher.retrieveResourceName(valueForKey, (MapValue<String, Object>)topicResourceMapForValue);
        }
        return null;
    }

    private static String retrieveResourceName(String topic, MapValue<String, Object> topicResourceMap) {
        if (topicResourceMap.containsKey((Object)topic)) {
            return ((ArrayValue)topicResourceMap.get((Object)topic)).getRefValue(0L).toString();
        }
        throw new BallerinaConnectorException("resource not specified for topic : " + topic);
    }
}

