/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.validator;

import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.openapi.validator.ErrorMessages;
import org.ballerinalang.openapi.validator.OpenAPIComponentSummary;
import org.ballerinalang.openapi.validator.OpenAPIPathSummary;
import org.ballerinalang.openapi.validator.OpenApiValidatorException;
import org.ballerinalang.openapi.validator.ResourceSummary;
import org.ballerinalang.openapi.validator.ValidatorUtil;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.SourceDirectoryManager;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

@SupportedAnnotationPackages(value={"ballerina/openapi"})
public class OpenAPIValidatorPlugin
extends AbstractCompilerPlugin {
    private DiagnosticLog dLog = null;
    private List<ResourceSummary> resourceSummaryList;
    private List<OpenAPIPathSummary> openAPISummaryList;
    private OpenAPIComponentSummary openAPIComponentSummary;
    private CompilerContext compilerContext;

    public void init(DiagnosticLog diagnosticLog) {
        this.dLog = diagnosticLog;
        this.resourceSummaryList = new ArrayList<ResourceSummary>();
        this.openAPISummaryList = new ArrayList<OpenAPIPathSummary>();
        this.openAPIComponentSummary = new OpenAPIComponentSummary();
    }

    public void setCompilerContext(CompilerContext context) {
        this.compilerContext = context;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        AnnotationAttachmentNode annotation = null;
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> operations = new ArrayList<String>();
        ArrayList<String> excludeTags = new ArrayList<String>();
        ArrayList<String> excludeOperations = new ArrayList<String>();
        this.openAPIComponentSummary = new OpenAPIComponentSummary();
        String contractURI = null;
        Boolean failOnErrors = true;
        for (AnnotationAttachmentNode ann : annotations) {
            if (!"openapi".equals(ann.getPackageAlias().getValue()) || !"ServiceInfo".equals(ann.getAnnotationName().getValue())) continue;
            annotation = ann;
        }
        if (annotation != null) {
            if (annotation.getExpression() instanceof BLangRecordLiteral) {
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)annotation.getExpression();
                for (RecordLiteralNode.RecordField field : recordLiteral.getFields()) {
                    BLangLiteral value;
                    BLangRecordLiteral.BLangRecordVarNameField valueExpr;
                    BLangRecordLiteral.BLangRecordVarNameField keyExpr;
                    if (field.isKeyValueField()) {
                        BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                        keyExpr = keyValue.getKey();
                        valueExpr = keyValue.getValue();
                    } else {
                        BLangRecordLiteral.BLangRecordVarNameField varNameField;
                        keyExpr = varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                        valueExpr = varNameField;
                    }
                    if (!(keyExpr instanceof BLangSimpleVarRef)) continue;
                    BLangSimpleVarRef contract = (BLangSimpleVarRef)keyExpr;
                    String key = contract.getVariableName().getValue();
                    if (key.equals("contract")) {
                        String projectDir;
                        if (!(valueExpr instanceof BLangLiteral)) continue;
                        value = (BLangLiteral)valueExpr;
                        SourceDirectoryManager sourceDirectoryManager = SourceDirectoryManager.getInstance((CompilerContext)this.compilerContext);
                        Path sourceDir = sourceDirectoryManager.getSourceDirectory().getPath();
                        Path pkg = Paths.get(serviceNode.getPosition().getSource().getPackageName(), new String[0]);
                        Path filePath = Paths.get(pkg.toString().equals(".") ? "" : pkg.toString(), serviceNode.getPosition().getSource().getCompilationUnitName().replaceAll("\\w*\\.bal", "").replaceAll("^/+", ""));
                        String string = projectDir = filePath.toString().contains(sourceDir.toString().replaceAll("^/+", "")) ? sourceDir.toString() : Paths.get(sourceDir.toString(), "src", filePath.toString()).toString();
                        if (value.getValue() instanceof String) {
                            String userUri = (String)value.getValue();
                            File file = null;
                            if (userUri.contains(projectDir)) {
                                file = new File(userUri);
                            } else {
                                try {
                                    file = new File(Paths.get(projectDir, userUri).toRealPath(new LinkOption[0]).toString());
                                }
                                catch (IOException e) {
                                    contractURI = Paths.get(userUri, new String[0]).toString();
                                }
                            }
                            if (file == null || !file.exists()) continue;
                            contractURI = file.getAbsolutePath();
                            continue;
                        }
                        this.dLog.logDiagnostic(Diagnostic.Kind.ERROR, annotation.getPosition(), (CharSequence)"Contract path should be applied as a string value");
                        continue;
                    }
                    if (key.equals("tags")) {
                        this.extractValues(annotation, tags, (BLangExpression)valueExpr, "Tags should be applied as string values");
                        continue;
                    }
                    if (key.equals("operations")) {
                        this.extractValues(annotation, operations, (BLangExpression)valueExpr, "Operations should be applied as string values");
                        continue;
                    }
                    if (key.equals("failOnErrors")) {
                        if (!(valueExpr instanceof BLangLiteral)) continue;
                        value = (BLangLiteral)valueExpr;
                        if (value.getValue() instanceof Boolean) {
                            failOnErrors = (Boolean)value.getValue();
                            continue;
                        }
                        this.dLog.logDiagnostic(Diagnostic.Kind.ERROR, annotation.getPosition(), (CharSequence)"FailOnErrors should be applied as boolean values");
                        continue;
                    }
                    if (key.equals("excludeTags")) {
                        this.extractValues(annotation, excludeTags, (BLangExpression)valueExpr, "ExcludeTags should be applied as string values");
                        continue;
                    }
                    if (!key.equals("excludeOperations")) continue;
                    this.extractValues(annotation, excludeOperations, (BLangExpression)valueExpr, "ExcludeOperations should be applied as string values");
                }
            }
            Diagnostic.Kind kind = failOnErrors != false ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            if (!Collections.disjoint(tags, excludeTags)) {
                this.dLog.logDiagnostic(Diagnostic.Kind.WARNING, annotation.getPosition(), (CharSequence)ErrorMessages.tagFilterEnable());
                excludeTags.clear();
            } else if (!Collections.disjoint(operations, excludeOperations)) {
                this.dLog.logDiagnostic(Diagnostic.Kind.WARNING, annotation.getPosition(), (CharSequence)ErrorMessages.operationFilterEnable());
                excludeOperations.clear();
            }
            if (contractURI != null) {
                try {
                    OpenAPI openAPI = ValidatorUtil.parseOpenAPIFile(contractURI);
                    ValidatorUtil.summarizeResources(this.resourceSummaryList, serviceNode);
                    ValidatorUtil.summarizeOpenAPI(this.openAPISummaryList, openAPI, this.openAPIComponentSummary);
                    ValidatorUtil.validateOpenApiAgainstResources(serviceNode, tags, operations, kind, excludeTags, excludeOperations, this.resourceSummaryList, this.openAPISummaryList, this.openAPIComponentSummary, this.dLog);
                    ValidatorUtil.validateResourcesAgainstOpenApi(tags, operations, kind, excludeTags, excludeOperations, this.resourceSummaryList, this.openAPISummaryList, this.openAPIComponentSummary, this.dLog);
                }
                catch (OpenApiValidatorException e) {
                    this.dLog.logDiagnostic(Diagnostic.Kind.ERROR, annotation.getPosition(), (CharSequence)e.getMessage());
                }
            }
        }
    }

    private void extractValues(AnnotationAttachmentNode annotation, List<String> operations, BLangExpression valueExpr, String s) {
        if (valueExpr instanceof BLangListConstructorExpr) {
            BLangListConstructorExpr bLangListConstructorExpr = (BLangListConstructorExpr)valueExpr;
            for (BLangExpression bLangExpression : bLangListConstructorExpr.getExpressions()) {
                if (!(bLangExpression instanceof BLangLiteral)) continue;
                BLangLiteral expression = (BLangLiteral)bLangExpression;
                if (expression.getValue() instanceof String) {
                    operations.add((String)expression.getValue());
                    continue;
                }
                this.dLog.logDiagnostic(Diagnostic.Kind.ERROR, annotation.getPosition(), (CharSequence)s);
            }
        }
    }

    public void process(PackageNode packageNode) {
    }
}

