/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TableValueImpl;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.table", version="0.4.0", functionName="next", receiver=@Receiver(type=TypeKind.OBJECT, structType="TableIterator", structPackage="ballerina/lang.table"), returnType={@ReturnType(type=TypeKind.RECORD)}, isPublic=true)
public class Next {
    public static Object next(Strand strand, ObjectValue t) {
        IteratorValue tableIterator = (IteratorValue)t.getNativeData("&iterator&");
        TableValueImpl table = (TableValueImpl)t.get(StringUtils.fromString((String)"t"));
        ArrayValueImpl keys = (ArrayValueImpl)t.get(StringUtils.fromString((String)"keys"));
        long initialSize = (Long)t.get(StringUtils.fromString((String)"size"));
        if (tableIterator == null) {
            tableIterator = table.getIterator();
            t.addNativeData("&iterator&", (Object)tableIterator);
            t.addNativeData("&returnedKeys&", new ArrayList());
        }
        ArrayList returnedKeys = (ArrayList)t.getNativeData("&returnedKeys&");
        Next.handleMutation(table, keys, returnedKeys, initialSize);
        if (tableIterator.hasNext()) {
            ArrayValue keyValueTuple = (ArrayValue)tableIterator.next();
            returnedKeys.add(keyValueTuple.get(0L));
            return BallerinaValues.createRecord((MapValue)new MapValueImpl(table.getIteratorNextReturnType()), (Object[])new Object[]{keyValueTuple.get(1L)});
        }
        return null;
    }

    private static void handleMutation(TableValueImpl table, ArrayValueImpl keys, List<Object> returnedKeys, long initialSize) {
        if (initialSize < (long)table.size() || initialSize > 0L && table.size() == 0) {
            throw BallerinaErrors.createError((String)BallerinaErrorReasons.ITERATOR_MUTABILITY_ERROR, (String)"Table was mutated after the iterator was created");
        }
        if (keys.isEmpty()) {
            return;
        }
        ArrayList<Object> currentKeys = new ArrayList<Object>(Arrays.asList(table.getKeys()));
        for (Object returnedValue : returnedKeys) {
            if (!TypeChecker.isEqual(currentKeys.get(0), (Object)returnedValue)) continue;
            currentKeys.remove(0);
        }
        ArrayValueImpl currentKeyArray = (ArrayValueImpl)BValueCreator.createArrayValue((BArrayType)((BArrayType)keys.getType()), (int)currentKeys.size());
        for (int i = 0; i < currentKeys.size(); ++i) {
            Object key = currentKeys.get(i);
            currentKeyArray.add((long)i, key);
        }
        if (!TypeChecker.isEqual((Object)currentKeyArray, (Object)keys)) {
            throw BallerinaErrors.createError((String)BallerinaErrorReasons.ITERATOR_MUTABILITY_ERROR, (String)"Table was mutated after the iterator was created");
        }
        keys.shift();
    }
}

