/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.langlib.xml.ErrorHandler;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.util.XMLNodeType;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.model.values.BXMLSequence;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.xml", functionName="elements", returnType={@ReturnType(type=TypeKind.XML)}, isPublic=true)
public class Elements
extends BlockingNativeCallableUnit {
    private static final String OPERATION = "get elements from xml";

    public void execute(Context ctx) {
        Object result = null;
        try {
            BXML value = (BXML)ctx.getRefArgument(0);
            result = value.getNodeType() == XMLNodeType.TEXT ? this.generateCodePointSequence(value) : value.elements();
        }
        catch (Throwable e) {
            ErrorHandler.handleXMLException(OPERATION, e);
        }
        ctx.setReturnValues(new BValue[]{result});
    }

    private BValue generateCodePointSequence(BXML value) {
        BValueArray array = new BValueArray();
        BIterator bIterator = value.newIterator();
        long i = 0L;
        while (bIterator.hasNext()) {
            BString next = (BString)bIterator.getNext();
            array.add(i++, (BRefType)next);
        }
        return new BXMLSequence(array);
    }

    public static XMLValue<?> elements(Strand strand, XMLValue<?> xml) {
        try {
            if (xml.getNodeType() == org.ballerinalang.jvm.XMLNodeType.TEXT) {
                return Elements.generateCodePointSequence(xml);
            }
            return xml.elements();
        }
        catch (Throwable e) {
            BLangExceptionHelper.handleXMLException((String)OPERATION, (Throwable)e);
            return null;
        }
    }

    private static XMLValue<?> generateCodePointSequence(XMLValue<?> value) {
        ArrayValue array = new ArrayValue((BType)new BArrayType(BTypes.typeXML));
        IteratorValue bIterator = value.getIterator();
        long i = 0L;
        while (bIterator.hasNext()) {
            array.add(i++, bIterator.next());
        }
        return new XMLSequence(array);
    }
}

