/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.langlib.xml.ErrorHandler;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.xml", functionName="getTextValue", returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class GetTextValue
extends BlockingNativeCallableUnit {
    private static final String OPERATION = "get text from xml";

    public void execute(Context ctx) {
        BString result = null;
        try {
            BXML xml = (BXML)ctx.getRefArgument(0);
            result = xml.getTextValue();
        }
        catch (Throwable e) {
            ErrorHandler.handleXMLException(OPERATION, e);
        }
        ctx.setReturnValues(new BValue[]{result});
    }

    public static String getTextValue(Strand strand, XMLValue<?> xml) {
        try {
            return xml.getTextValue();
        }
        catch (Throwable e) {
            BLangExceptionHelper.handleXMLException((String)OPERATION, (Throwable)e);
            return null;
        }
    }
}

