/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.XMLValueUtil;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.langlib.xml.IsComment;
import org.ballerinalang.langlib.xml.IsProcessingInstruction;
import org.ballerinalang.langlib.xml.IsText;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.xml", version="0.8.0", functionName="getContent", args={@Argument(name="xmlValue", type=TypeKind.XML)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class GetContent {
    public static BString getContent(Strand strand, Object xmlVal) {
        XMLValue value = (XMLValue)xmlVal;
        if (IsText.isText(strand, value)) {
            return StringUtils.fromString((String)value.getTextValue());
        }
        if (IsProcessingInstruction.isProcessingInstruction(strand, value)) {
            return StringUtils.fromString((String)XMLValueUtil.getPIContent((XMLValue)value));
        }
        if (IsComment.isComment(strand, value)) {
            return StringUtils.fromString((String)XMLValueUtil.getCommentContent((XMLValue)value));
        }
        throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.XML_FUNC_TYPE_ERROR, (Object[])new Object[]{"getContent", "text|processing instruction|comment"});
    }
}

