/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandler.class);

    public static void handleInvalidJsonPath(String operation, Exception e) {
        throw new BallerinaException("Failed to " + operation + ". Invalid jsonpath: " + e.getMessage());
    }

    public static void handleNonExistingJsonpPath(String operation, String jsonPath, Exception e) {
        throw new BallerinaException("Failed to " + operation + ". Jsonpath " + jsonPath + " does not match any element: " + e.getMessage());
    }

    public static void handleJsonPathException(String operation, Throwable e) {
        throw new BallerinaException("Failed to " + operation + ". Error while executing jsonpath: " + e.getMessage());
    }

    public static void handleMalformedJson(String operation, Exception e) {
        if (e.getCause() != null) {
            throw new BallerinaException("Failed to " + operation + " due to malformed json: " + e.getCause().getMessage());
        }
        throw new BallerinaException("Failed to " + operation + " due to malformed json: " + e.getMessage());
    }

    public static void handleJsonException(String reason, String operation, Throwable e) {
        if (e instanceof BallerinaException && ((BallerinaException)e).getDetail() != null) {
            throw new BallerinaException(reason, "Failed to " + operation + ": " + ((BallerinaException)e).getDetail());
        }
        if (e instanceof BLangFreezeException) {
            throw new BallerinaException(reason, "Failed to " + operation + ": " + ((BLangFreezeException)e).getDetail());
        }
        if (e.getCause() != null) {
            throw new BallerinaException(reason, "Failed to " + operation + ": " + e.getCause().getMessage());
        }
        throw new BallerinaException(reason, "Failed to " + operation + ": " + e.getMessage());
    }

    public static void handleInvalidXPath(String operation, Exception e) {
        throw new BallerinaException("Failed to " + operation + ". Invalid xpath: " + e.getMessage());
    }

    public static void handleXMLException(String operation, Throwable e) {
        if (e instanceof BallerinaException && ((BallerinaException)e).getDetail() != null) {
            throw new BallerinaException(BallerinaErrorReasons.XML_OPERATION_ERROR.getValue(), "Failed to " + operation + ": " + ((BallerinaException)e).getDetail());
        }
        if (e instanceof BLangFreezeException) {
            throw new BallerinaException(BallerinaErrorReasons.XML_OPERATION_ERROR.getValue(), "Failed to " + operation + ": " + ((BLangFreezeException)e).getDetail());
        }
        if (e.getCause() != null) {
            throw new BallerinaException(BallerinaErrorReasons.XML_OPERATION_ERROR.getValue(), "Failed to " + operation + ": " + e.getCause().getMessage());
        }
        throw new BallerinaException(BallerinaErrorReasons.XML_OPERATION_ERROR.getValue(), "Failed to " + operation + ": " + e.getMessage());
    }

    public static void handleUndefineHeader(String headerName) {
        throw new BallerinaException("Header '" + headerName + "' not present in the message");
    }

    public static void logWarn(String operation, String msg) {
        throw new BallerinaException("Failed to " + operation + ". " + msg);
    }
}

